/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.operations.NuxeoDriveOperationHelper;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.CanMove", category="Services", label="Nuxeo Drive: Can move")
public class NuxeoDriveCanMove {
    private static final Log log = LogFactory.getLog(NuxeoDriveCanMove.class);
    public static final String ID = "NuxeoDrive.CanMove";
    @Context
    protected OperationContext ctx;
    @Param(name="srcId")
    protected String srcId;
    @Param(name="destId")
    protected String destId;

    @OperationMethod
    public Blob run() throws ClientException, IOException {
        boolean canMove;
        block2: {
            canMove = false;
            try {
                FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class);
                canMove = fileSystemItemManager.canMove(this.srcId, this.destId, this.ctx.getPrincipal());
            }
            catch (RootlessItemException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)String.format("Cannot move %s to %s: %s", this.srcId, this.destId, e.getMessage()), (Throwable)e);
            }
        }
        return NuxeoDriveOperationHelper.asJSONBlob(canMove);
    }
}

