/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;

class DesCbcMd5Encryption
extends EncryptionEngine {
    private static final byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    DesCbcMd5Encryption() {
    }

    public EncryptionType getEncryptionType() {
        return EncryptionType.DES_CBC_MD5;
    }

    public int getConfounderLength() {
        return 8;
    }

    public int getChecksumLength() {
        return 16;
    }

    public byte[] calculateIntegrity(byte[] data, byte[] key, KeyUsage usage) {
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            return digester.digest(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }

    public byte[] getDecryptedData(EncryptionKey key, EncryptedData data, KeyUsage usage) throws KerberosException {
        byte[] decryptedData = this.decrypt(data.getCipherText(), key.getKeyValue());
        byte[] oldChecksum = new byte[this.getChecksumLength()];
        System.arraycopy(decryptedData, this.getConfounderLength(), oldChecksum, 0, oldChecksum.length);
        for (int i = this.getConfounderLength(); i < this.getConfounderLength() + this.getChecksumLength(); ++i) {
            decryptedData[i] = 0;
        }
        byte[] newChecksum = this.calculateIntegrity(decryptedData, key.getKeyValue(), usage);
        if (!Arrays.equals(oldChecksum, newChecksum)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
        }
        return this.removeLeadingBytes(decryptedData, this.getConfounderLength(), this.getChecksumLength());
    }

    public EncryptedData getEncryptedData(EncryptionKey key, byte[] plainText, KeyUsage usage) {
        byte[] conFounder = this.getRandomBytes(this.getConfounderLength());
        byte[] zeroedChecksum = new byte[this.getChecksumLength()];
        byte[] paddedPlainText = this.padString(plainText);
        byte[] dataBytes = this.concatenateBytes(conFounder, this.concatenateBytes(zeroedChecksum, paddedPlainText));
        byte[] checksumBytes = this.calculateIntegrity(dataBytes, null, usage);
        byte[] paddedDataBytes = this.padString(dataBytes);
        for (int i = this.getConfounderLength(); i < this.getConfounderLength() + this.getChecksumLength(); ++i) {
            paddedDataBytes[i] = checksumBytes[i - this.getConfounderLength()];
        }
        byte[] encryptedData = this.encrypt(paddedDataBytes, key.getKeyValue());
        return new EncryptedData(this.getEncryptionType(), key.getKeyVersion(), encryptedData);
    }

    public byte[] encrypt(byte[] plainText, byte[] keyBytes) {
        return this.processCipher(true, plainText, keyBytes);
    }

    public byte[] decrypt(byte[] cipherText, byte[] keyBytes) {
        return this.processCipher(false, cipherText, keyBytes);
    }

    private byte[] processCipher(boolean isEncrypt, byte[] data, byte[] keyBytes) {
        try {
            Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
            SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
            IvParameterSpec paramSpec = new IvParameterSpec(iv);
            if (isEncrypt) {
                cipher.init(1, (Key)key, paramSpec);
            } else {
                cipher.init(2, (Key)key, paramSpec);
            }
            return cipher.doFinal(data);
        }
        catch (GeneralSecurityException nsae) {
            nsae.printStackTrace();
            return null;
        }
    }
}

