/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionTypeInfoEntry;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncryptionTypeInfoDecoder {
    public EncryptionTypeInfoEntry[] decode(byte[] encodedEntries) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedEntries);
        DERSequence sequence = (DERSequence)ais.readObject();
        return EncryptionTypeInfoDecoder.decodeSequence(sequence);
    }

    protected static EncryptionTypeInfoEntry[] decodeSequence(DERSequence sequence) {
        EncryptionTypeInfoEntry[] entrySequence = new EncryptionTypeInfoEntry[sequence.size()];
        int ii = 0;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERSequence object = (DERSequence)e.nextElement();
            entrySequence[ii] = EncryptionTypeInfoDecoder.decode(object);
            ++ii;
        }
        return entrySequence;
    }

    protected static EncryptionTypeInfoEntry decode(DERSequence sequence) {
        EncryptionType encryptionType = EncryptionType.NULL;
        byte[] salt = new byte[]{};
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger type = (DERInteger)derObject;
                    encryptionType = EncryptionType.getTypeByOrdinal(type.intValue());
                    break;
                }
                case 1: {
                    DEROctetString value = (DEROctetString)derObject;
                    salt = value.getOctets();
                }
            }
        }
        return new EncryptionTypeInfoEntry(encryptionType, salt);
    }
}

