/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.PageProviderRegistry;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class PageProviderServiceImpl
extends DefaultComponent
implements PageProviderService {
    private static final long serialVersionUID = 1L;
    public static final String PROVIDER_EP = "providers";
    protected PageProviderRegistry providerReg = new PageProviderRegistry();

    @Override
    public PageProviderDefinition getPageProviderDefinition(String name) {
        return this.providerReg.getPageProvider(name);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) throws ClientException {
        PageProvider<DocumentModel> pageProvider;
        if (desc == null) {
            return null;
        }
        if (desc instanceof CoreQueryPageProviderDescriptor) {
            pageProvider = new CoreQueryDocumentPageProvider();
        } else if (desc instanceof GenericPageProviderDescriptor) {
            Class<PageProvider<?>> klass = ((GenericPageProviderDescriptor)desc).getPageProviderClass();
            if (klass == null) {
                throw new ClientException(String.format("Cannot find class for page provider definition with name '%s': check ERROR logs at startup", name));
            }
            try {
                pageProvider = klass.newInstance();
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        } else {
            throw new ClientException(String.format("Invalid page provider definition with name '%s'", name));
        }
        pageProvider.setName(name);
        pageProvider.setDefinition(desc);
        HashMap<String, Serializable> allProps = new HashMap<String, Serializable>();
        Map<String, String> localProps = desc.getProperties();
        if (localProps != null) {
            allProps.putAll(localProps);
        }
        if (properties != null) {
            allProps.putAll(properties);
        }
        pageProvider.setProperties(allProps);
        pageProvider.setSortable(desc.isSortable());
        pageProvider.setParameters(parameters);
        Long maxPageSize = desc.getMaxPageSize();
        if (maxPageSize != null) {
            pageProvider.setMaxPageSize(maxPageSize);
        }
        if (sortInfos == null) {
            pageProvider.setSortInfos(desc.getSortInfos());
        } else {
            pageProvider.setSortInfos(sortInfos);
        }
        if (pageSize == null || pageSize < 0L) {
            pageProvider.setPageSize(desc.getPageSize());
        } else {
            pageProvider.setPageSize(pageSize);
        }
        if (currentPage != null && currentPage > 0L) {
            pageProvider.setCurrentPage(currentPage);
        }
        return pageProvider;
    }

    @Override
    public PageProvider<?> getPageProvider(String name, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) throws ClientException {
        PageProviderDefinition desc = this.providerReg.getPageProvider(name);
        if (desc == null) {
            throw new ClientException(String.format("Could not resolve page provider with name '%s'", name));
        }
        return this.getPageProvider(name, desc, sortInfos, pageSize, currentPage, properties, parameters);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PROVIDER_EP.equals(extensionPoint)) {
            PageProviderDefinition desc = (PageProviderDefinition)contribution;
            this.providerReg.addContribution(desc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (PROVIDER_EP.equals(extensionPoint)) {
            PageProviderDefinition desc = (PageProviderDefinition)contribution;
            this.providerReg.removeContribution(desc);
        }
    }
}

