/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.util.Map;
import org.artofsolving.jodconverter.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeUtils {
    public static final String SERVICE_DESKTOP = "com.sun.star.frame.Desktop";

    private OfficeUtils() {
        throw new AssertionError((Object)"utility class must not be instantiated");
    }

    public static <T> T cast(Class<T> type, Object object) {
        return (T)UnoRuntime.queryInterface(type, (Object)object);
    }

    public static PropertyValue property(String name, Object value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = name;
        propertyValue.Value = value;
        return propertyValue;
    }

    public static PropertyValue[] toUnoProperties(Map<String, ?> properties) {
        PropertyValue[] propertyValues = new PropertyValue[properties.size()];
        int i = 0;
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map subProperties = (Map)value;
                value = OfficeUtils.toUnoProperties(subProperties);
            }
            propertyValues[i++] = OfficeUtils.property(entry.getKey(), value);
        }
        return propertyValues;
    }

    public static String toUrl(File file) {
        String url = "file://" + file.toURI().getRawPath();
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static File getDefaultOfficeHome() {
        String officeHome = System.getProperty("office.home");
        if (officeHome == null) {
            officeHome = PlatformUtils.findOfficeHome();
        }
        return new File(officeHome);
    }

    public static File getDefaultProfileDir() {
        String officeProfile = System.getProperty("office.profile");
        if (officeProfile == null) {
            officeProfile = PlatformUtils.findOfficeProfileDir();
        }
        return new File(officeProfile);
    }

    public static File getOfficeExecutable(File officeHome) {
        if (PlatformUtils.isMac()) {
            return new File(officeHome, "MacOS/soffice.bin");
        }
        return new File(officeHome, "program/soffice.bin");
    }
}

