/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;
import org.jboss.seam.document.DocumentData;
import org.jboss.seam.document.DocumentStore;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pdf.ui.FormComponent;

public class UIForm
extends FormComponent {
    public static final String COMPONENT_FAMILY = "org.jboss.seam.pdf.UIForm";
    private Log log = Logging.getLog(((Object)((Object)this)).getClass());
    private String URL;
    PdfReader reader;
    PdfStamper stamper;
    AcroFields fields;
    ByteArrayOutputStream buffer;

    public String getURL() {
        return (String)this.valueOf("URL", this.URL);
    }

    public void setURL(String url) {
        this.URL = url;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        this.reader = new PdfReader(new URL(this.getURL()));
        this.buffer = new ByteArrayOutputStream();
        try {
            this.stamper = new PdfStamper(this.reader, (OutputStream)this.buffer);
        }
        catch (DocumentException e) {
            throw new FacesException("Could not create PDF stamper", (Throwable)e);
        }
        this.fields = this.stamper.getAcroFields();
        Contexts.getEventContext().set("acrofields", (Object)this.fields);
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        this.stamper.setFormFlattening(true);
        try {
            this.stamper.close();
        }
        catch (DocumentException e) {
            throw new FacesException("Could not flush PDF", (Throwable)e);
        }
        String viewId = Pages.getViewId((FacesContext)facesContext);
        String baseName = UIForm.baseNameForViewId(viewId);
        DocumentStore store = DocumentStore.instance();
        DocumentData.DocumentType documentType = new DocumentData.DocumentType("pdf", "application/pdf");
        DocumentData documentData = new DocumentData(baseName, documentType, this.buffer.toByteArray());
        String id = store.newId();
        String url = store.preferredUrlForContent(baseName, documentType.getExtension(), id);
        url = Manager.instance().encodeConversationId(url, viewId);
        store.saveData(id, documentData);
        this.log.info((Object)"Redirecting to #0", new Object[]{url});
        facesContext.getExternalContext().redirect(url);
    }

    public static String baseNameForViewId(String viewId) {
        int pos = viewId.lastIndexOf("/");
        if (pos != -1) {
            viewId = viewId.substring(pos + 1);
        }
        if ((pos = viewId.lastIndexOf(".")) != -1) {
            viewId = viewId.substring(0, pos);
        }
        return viewId;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }
}

