/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.LogEntry;

@Operation(id="Audit.Log", category="Services", label="Log Event In Audit", description="Log events into audit for each of the input document. The operation accept as input one ore more documents that are returned back as the output.")
public class AuditLog {
    public static final String ID = "Audit.Log";
    @Context
    protected AuditLogger logger;
    @Context
    protected OperationContext ctx;
    @Param(name="event", widget="AuditEvent")
    protected String event;
    @Param(name="category", required=false, values={"Automation"})
    protected String category = "Automation";
    @Param(name="comment", required=false, widget="TextArea")
    protected String comment = "";

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        Principal principal = this.ctx.getPrincipal();
        LogEntry entry = this.newEntry(doc, principal != null ? principal.getName() : null, new Date());
        this.logger.addLogEntries(Collections.singletonList(entry));
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        Date date = new Date();
        Principal principal = this.ctx.getPrincipal();
        String uname = principal != null ? principal.getName() : null;
        for (DocumentModel doc : docs) {
            entries.add(this.newEntry(doc, uname, date));
        }
        this.logger.addLogEntries(entries);
        return docs;
    }

    protected LogEntry newEntry(DocumentModel doc, String principal, Date date) {
        LogEntry entry = this.logger.newLogEntry();
        entry.setEventId(this.event);
        entry.setEventDate(new Date());
        entry.setCategory(this.category);
        entry.setDocUUID(doc.getId());
        entry.setDocPath(doc.getPathAsString());
        entry.setComment(this.comment);
        entry.setPrincipalName(principal);
        entry.setDocType(doc.getType());
        entry.setRepositoryId(doc.getRepositoryName());
        try {
            entry.setDocLifeCycle(doc.getCurrentLifeCycleState());
        }
        catch (Exception e) {
            // empty catch block
        }
        return entry;
    }
}

