/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.Serializable;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;

@Operation(id="Relations.CreateRelation", category="Services", label="Create Relation", description="Create a relation between 2 documents. The subject of the relation will be the input of the operation and the object of the relation will be retrieved from the context using the 'object' field. The 'predicate' field specify the relation predicate. The 'outgoing' flag indicates the direction of the relation - the default is false which means the relation will go from the input object to the object specified as 'object' parameter. Return back the subject document.")
public class CreateRelation {
    public static final String ID = "Relations.CreateRelation";
    @Context
    protected CoreSession session;
    @Context
    protected RelationManager relations;
    @Param(name="object")
    protected DocumentModel object;
    @Param(name="predicate")
    protected String predicate;
    @Param(name="outgoing", required=false, values={"false"})
    protected boolean outgoing = false;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        QNameResource subject = this.getDocumentResource(doc);
        QNameResource obj = this.getDocumentResource(this.object);
        Resource predicate = this.getPredicate();
        StatementImpl stmt = this.outgoing ? new StatementImpl((Node)obj, (Node)predicate, (Node)subject) : new StatementImpl((Node)subject, (Node)predicate, (Node)obj);
        this.relations.getGraphByName("default").add((Statement)stmt);
        return doc;
    }

    protected QNameResource getDocumentResource(DocumentModel document) throws ClientException {
        return (QNameResource)this.relations.getResource("http://www.nuxeo.org/document/uid/", (Serializable)document, null);
    }

    protected Resource getPredicate() {
        return this.predicate != null && this.predicate.length() > 0 ? new ResourceImpl(this.predicate) : null;
    }
}

