/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deployment.preprocessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.deployment.preprocessor.TemplateDescriptor;
import org.nuxeo.runtime.deployment.preprocessor.install.CommandProcessor;
import org.nuxeo.runtime.deployment.preprocessor.install.DOMCommandsParser;
import org.nuxeo.runtime.deployment.preprocessor.template.TemplateContribution;
import org.w3c.dom.DocumentFragment;

@XObject(value="fragment")
public class FragmentDescriptor {
    private static final Log log = LogFactory.getLog(FragmentDescriptor.class);
    public static final FragmentDescriptor ALL = new FragmentDescriptor("all", true);
    @XNode(value="@name")
    public String name;
    @XNode(value="@version")
    public int version = 0;
    public String fileName;
    public String filePath;
    @XNode(value="@startLevel")
    @Deprecated
    public int startLevel;
    @XNodeList(value="extension", type=TemplateContribution[].class, componentType=TemplateContribution.class)
    public TemplateContribution[] contributions;
    @XNodeList(value="require", type=ArrayList.class, componentType=String.class)
    public List<String> requires;
    @XNodeList(value="requiredBy", type=String[].class, componentType=String.class)
    public String[] requiredBy;
    @XNodeMap(value="template", key="@name", type=HashMap.class, componentType=TemplateDescriptor.class)
    public Map<String, TemplateDescriptor> templates;
    public CommandProcessor install;
    public CommandProcessor uninstall;
    protected boolean isMarker;

    public FragmentDescriptor() {
    }

    public FragmentDescriptor(String name, boolean isMarker) {
        this.name = name;
        this.isMarker = isMarker;
    }

    public boolean isMarker() {
        return this.isMarker;
    }

    @XContent(value="install")
    public void setInstallCommands(DocumentFragment df) {
        try {
            this.install = DOMCommandsParser.parse(df);
        }
        catch (Exception e) {
            log.error((Object)"Failed to set install commands");
        }
    }

    @XContent(value="uninstall")
    public void setUninstallCommands(DocumentFragment df) {
        try {
            this.uninstall = DOMCommandsParser.parse(df);
        }
        catch (Exception e) {
            log.error((Object)"Failed to set uninstall commands");
        }
    }

    public String toString() {
        return this.name + " [" + this.fileName + ']';
    }
}

