/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.enumeration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.referral.ReferralLut;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.exception.LdapReferralException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferralHandlingEnumeration
implements NamingEnumeration<SearchResult> {
    private final Logger log = LoggerFactory.getLogger(ReferralHandlingEnumeration.class);
    private final List<SearchResult> referrals = new ArrayList<SearchResult>();
    private final NamingEnumeration<SearchResult> underlying;
    private final ReferralLut lut;
    private final PartitionNexus nexus;
    private final boolean doThrow;
    private final int scope;
    private SearchResult prefetched;
    private int refIndex = -1;
    private Map<String, OidNormalizer> normalizerMap;

    public ReferralHandlingEnumeration(NamingEnumeration<SearchResult> underlying, ReferralLut lut, AttributeTypeRegistry registry, PartitionNexus nexus, int scope, boolean doThrow) throws NamingException {
        this.normalizerMap = registry.getNormalizerMapping();
        this.underlying = underlying;
        this.doThrow = doThrow;
        this.lut = lut;
        this.scope = scope;
        this.nexus = nexus;
        this.prefetch();
    }

    public void prefetch() throws NamingException {
        while (this.underlying.hasMore()) {
            SearchResult result = this.underlying.next();
            LdapDN dn = new LdapDN(result.getName());
            dn.normalize(this.normalizerMap);
            if (this.lut.isReferral(dn)) {
                this.referrals.add(result);
                continue;
            }
            this.prefetched = result;
            return;
        }
        ++this.refIndex;
        this.prefetched = this.referrals.get(this.refIndex);
        if (this.doThrow) {
            this.doReferralExceptionOnSearchBase();
        }
    }

    @Override
    public SearchResult next() throws NamingException {
        SearchResult retval = this.prefetched;
        this.prefetch();
        return retval;
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.underlying.hasMore() || this.refIndex < this.referrals.size();
    }

    @Override
    public void close() throws NamingException {
        this.underlying.close();
        this.referrals.clear();
        this.prefetched = null;
        this.refIndex = Integer.MAX_VALUE;
    }

    @Override
    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException e) {
            this.log.error("Naming enumeration failure.  Closing enumeration early!", (Throwable)e);
            try {
                this.close();
            }
            catch (NamingException e1) {
                this.log.error("Naming enumeration failure.  Failed to properly close enumeration!", (Throwable)e1);
            }
            return false;
        }
    }

    @Override
    public SearchResult nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            this.log.error("NamingEnumeration closed prematurely without returning elements.", (Throwable)e);
            throw new NoSuchElementException("NamingEnumeration closed prematurely without returning elements.");
        }
    }

    public void doReferralExceptionOnSearchBase() throws NamingException {
        Attribute refs = this.prefetched.getAttributes().get("ref");
        if (refs == null) {
            LdapDN prefetchedDn = new LdapDN(this.prefetched.getName());
            prefetchedDn.normalize(this.normalizerMap);
            refs = this.nexus.lookup(new LookupOperationContext(prefetchedDn)).get("ref");
        }
        if (refs == null) {
            throw new IllegalStateException(this.prefetched.getName() + " does not seem like a referral but we're trying to handle it as one.");
        }
        ArrayList<String> list = new ArrayList<String>(refs.size());
        for (int ii = 0; ii < refs.size(); ++ii) {
            String val = (String)refs.get(ii);
            if (!val.startsWith("ldap")) {
                list.add(val);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(val.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                this.log.error("Bad URL (" + val + ") for ref in " + this.prefetched.getName() + ".  Reference will be ignored.");
            }
            StringBuilder buf = new StringBuilder();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(ldapUrl.getDn());
            buf.append("??");
            switch (this.scope) {
                case 2: {
                    buf.append("sub");
                    break;
                }
                case 1: {
                    buf.append("base");
                    break;
                }
                case 0: {
                    buf.append("base");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown recognized search scope: " + this.scope);
                }
            }
            list.add(buf.toString());
        }
        LdapReferralException lre = new LdapReferralException(list);
        throw lre;
    }
}

