/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.authn.AuthenticationService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.jndi.JavaLdapSupport;
import org.apache.directory.server.core.jndi.LdapJndiProperties;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerContext
implements EventContext {
    public static final String DELETE_OLD_RDN_PROP = "java.naming.ldap.deleteRDN";
    protected static final Control[] EMPTY_CONTROLS = new Control[0];
    private final DirectoryService service;
    private final PartitionNexus nexusProxy;
    private final Hashtable env;
    private final LdapDN dn;
    private final Set listeners = new HashSet();
    private LdapPrincipal principal;
    protected Control[] requestControls = EMPTY_CONTROLS;
    protected Control[] responseControls = EMPTY_CONTROLS;
    protected Control[] connectControls = EMPTY_CONTROLS;

    protected ServerContext(DirectoryService service, Hashtable env) throws NamingException {
        this.service = service;
        this.nexusProxy = new PartitionNexusProxy(this, service);
        DirectoryServiceConfiguration cfg = service.getConfiguration();
        this.env = (Hashtable)cfg.getEnvironment().clone();
        this.env.putAll(env);
        LdapJndiProperties props = LdapJndiProperties.getLdapJndiProperties(this.env);
        this.dn = props.getProviderDn();
        this.doBindOperation(props.getBindDn(), props.getCredentials(), props.getAuthenticationMechanisms(), props.getSaslAuthId());
        if (!this.nexusProxy.hasEntry(new EntryOperationContext(this.dn))) {
            throw new NameNotFoundException(this.dn + " does not exist");
        }
    }

    protected ServerContext(DirectoryService service, LdapPrincipal principal, Name dn) throws NamingException {
        this.service = service;
        this.dn = (LdapDN)dn.clone();
        this.env = (Hashtable)service.getConfiguration().getEnvironment().clone();
        this.env.put("java.naming.provider.url", dn.toString());
        this.nexusProxy = new PartitionNexusProxy(this, service);
        this.principal = principal;
    }

    protected void doAddOperation(LdapDN target, Attributes attributes) throws NamingException {
        AddOperationContext opCtx = new AddOperationContext(target, attributes);
        opCtx.addRequestControls(this.requestControls);
        this.nexusProxy.add(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected void doDeleteOperation(LdapDN target) throws NamingException {
        DeleteOperationContext opCtx = new DeleteOperationContext(target);
        opCtx.addRequestControls(this.requestControls);
        this.nexusProxy.delete(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected NamingEnumeration doSearchOperation(LdapDN dn, Map env, ExprNode filter, SearchControls searchControls) throws NamingException {
        SearchOperationContext opCtx = new SearchOperationContext(dn, env, filter, searchControls);
        opCtx.addRequestControls(this.requestControls);
        NamingEnumeration<SearchResult> results = this.nexusProxy.search(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
        return results;
    }

    protected NamingEnumeration doListOperation(LdapDN target) throws NamingException {
        ListOperationContext opCtx = new ListOperationContext(target);
        opCtx.addRequestControls(this.requestControls);
        NamingEnumeration<SearchResult> results = this.nexusProxy.list(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
        return results;
    }

    protected Attributes doGetRootDSEOperation(LdapDN target) throws NamingException {
        GetRootDSEOperationContext opCtx = new GetRootDSEOperationContext(target);
        opCtx.addRequestControls(this.requestControls);
        return this.nexusProxy.getRootDSE(opCtx);
    }

    protected Attributes doLookupOperation(LdapDN target) throws NamingException {
        LookupOperationContext opCtx = new LookupOperationContext(target);
        opCtx.addRequestControls(this.requestControls);
        Attributes attributes = this.nexusProxy.lookup(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
        return attributes;
    }

    protected Attributes doLookupOperation(LdapDN target, String[] attrIds) throws NamingException {
        LookupOperationContext opCtx = new LookupOperationContext(target, attrIds);
        opCtx.addRequestControls(this.requestControls);
        Attributes attributes = this.nexusProxy.lookup(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
        return attributes;
    }

    protected void doBindOperation(LdapDN bindDn, byte[] credentials, List<String> mechanisms, String saslAuthId) throws NamingException {
        BindOperationContext opCtx = new BindOperationContext();
        opCtx.setDn(bindDn);
        opCtx.setCredentials(credentials);
        opCtx.setMechanisms(mechanisms);
        opCtx.setSaslAuthId(saslAuthId);
        opCtx.addRequestControls(this.requestControls);
        this.nexusProxy.bind(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected void doMoveAndRenameOperation(LdapDN oldDn, LdapDN parent, String newRdn, boolean delOldDn) throws NamingException {
        MoveAndRenameOperationContext opCtx = new MoveAndRenameOperationContext(oldDn, parent, newRdn, delOldDn);
        opCtx.addRequestControls(this.requestControls);
        this.nexusProxy.moveAndRename(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected void doModifyOperation(LdapDN dn, ModificationItemImpl[] modItems) throws NamingException {
        ModifyOperationContext opCtx = new ModifyOperationContext(dn, modItems);
        opCtx.addRequestControls(this.requestControls);
        this.nexusProxy.modify(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected void doMove(LdapDN oldDn, LdapDN target) throws NamingException {
        MoveOperationContext opCtx = new MoveOperationContext(oldDn, target);
        opCtx.addRequestControls(this.requestControls);
        this.nexusProxy.move(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected void doRename(LdapDN oldDn, String newRdn, boolean delOldRdn) throws NamingException {
        RenameOperationContext opCtx = new RenameOperationContext(oldDn, newRdn, delOldRdn);
        opCtx.addRequestControls(this.requestControls);
        this.nexusProxy.rename(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    public abstract ServerContext getRootContext() throws NamingException;

    public DirectoryService getService() {
        return this.service;
    }

    public LdapPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(AuthenticationService.TrustedPrincipalWrapper wrapper) {
        this.principal = wrapper.getPrincipal();
    }

    protected PartitionNexus getNexusProxy() {
        return this.nexusProxy;
    }

    protected Name getDn() {
        return this.dn;
    }

    @Override
    public void close() throws NamingException {
        Iterator list = this.listeners.iterator();
        while (list.hasNext()) {
            ((PartitionNexusProxy)this.nexusProxy).removeNamingListener(this, (NamingListener)list.next());
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.dn.getUpName();
    }

    public Hashtable getEnvironment() {
        return this.env;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext((Name)new LdapDN(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        AttributesImpl attributes = new AttributesImpl();
        LdapDN target = this.buildTarget(name);
        AttributeImpl attribute = new AttributeImpl("objectClass");
        attribute.add("top");
        attribute.add("javaContainer");
        attributes.put((Attribute)attribute);
        Rdn rdn = target.getRdn();
        if (rdn != null) {
            if (!"cn".equals(rdn.getNormType())) {
                throw new LdapSchemaViolationException(name + " does not contains the mandatory 'cn' attribute for JavaContainer ObjectClass!", ResultCodeEnum.OBJECT_CLASS_VIOLATION);
            }
        } else {
            throw new LdapSchemaViolationException(name + " does not contains the mandatory 'cn' attribute for JavaContainer ObjectClass!", ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        attributes.put(rdn.getUpType(), rdn.getUpValue());
        this.doAddOperation(target, (Attributes)attributes);
        return new ServerLdapContext(this.service, this.principal, target);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext((Name)new LdapDN(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        LdapDN target = this.buildTarget(name);
        if (target.size() == 0) {
            throw new LdapNoPermissionException("can't delete the rootDSE");
        }
        this.doDeleteOperation(target);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind((Name)new LdapDN(name), obj);
    }

    private void injectRdnAttributeValues(LdapDN target, Attributes attributes) throws NamingException {
        Rdn rdn = target.getRdn(target.size() - 1);
        if (rdn.size() == 1) {
            attributes.put(rdn.getUpType(), rdn.getValue());
        } else {
            for (AttributeTypeAndValue atav : rdn) {
                attributes.put(atav.getUpType(), atav.getValue());
            }
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.env, null);
        Attributes outAttrs = AttributeUtils.toCaseInsensitive((Attributes)res.getAttributes());
        if (outAttrs != null) {
            LdapDN target = this.buildTarget(name);
            this.doAddOperation(target, outAttrs);
            return;
        }
        if (obj instanceof Referenceable) {
            throw new NamingException("Do not know how to store Referenceables yet!");
        }
        if (obj instanceof Reference) {
            throw new NamingException("Do not know how to store References yet!");
        }
        if (obj instanceof Serializable) {
            AttributesImpl attributes = new AttributesImpl();
            if (outAttrs != null && outAttrs.size() > 0) {
                NamingEnumeration<? extends Attribute> list = outAttrs.getAll();
                while (list.hasMore()) {
                    attributes.put(list.next());
                }
            }
            LdapDN target = this.buildTarget(name);
            this.injectRdnAttributeValues(target, (Attributes)attributes);
            JavaLdapSupport.serialize((Attributes)attributes, obj);
            this.doAddOperation(target, (Attributes)attributes);
        } else if (obj instanceof DirContext) {
            Attributes attributes = ((DirContext)obj).getAttributes("");
            if (outAttrs != null && outAttrs.size() > 0) {
                NamingEnumeration<? extends Attribute> list = outAttrs.getAll();
                while (list.hasMore()) {
                    attributes.put(list.next());
                }
            }
            LdapDN target = this.buildTarget(name);
            this.injectRdnAttributeValues(target, attributes);
            this.doAddOperation(target, attributes);
        } else {
            throw new NamingException("Can't find a way to bind: " + obj);
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename((Name)new LdapDN(oldName), (Name)new LdapDN(newName));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        LdapDN oldDn = this.buildTarget(oldName);
        LdapDN newDn = this.buildTarget(newName);
        if (oldDn.size() == 0) {
            throw new LdapNoPermissionException("can't rename the rootDSE");
        }
        LdapDN oldBase = (LdapDN)oldName.clone();
        oldBase.remove(oldName.size() - 1);
        LdapDN newBase = (LdapDN)newName.clone();
        newBase.remove(newName.size() - 1);
        String newRdn = newName.get(newName.size() - 1);
        String oldRdn = oldName.get(oldName.size() - 1);
        boolean delOldRdn = true;
        if (null != this.env.get(DELETE_OLD_RDN_PROP)) {
            String delOldRdnStr = (String)this.env.get(DELETE_OLD_RDN_PROP);
            boolean bl = delOldRdn = !delOldRdnStr.equalsIgnoreCase("false") && !delOldRdnStr.equalsIgnoreCase("no") && !delOldRdnStr.equals("0");
        }
        if (oldName.size() == newName.size() && oldBase.equals((Object)newBase)) {
            this.doRename(oldDn, newRdn, delOldRdn);
        } else {
            LdapDN target = (LdapDN)newDn.clone();
            target.remove(newDn.size() - 1);
            if (newRdn.equalsIgnoreCase(oldRdn)) {
                this.doMove(oldDn, target);
            } else {
                this.doMoveAndRenameOperation(oldDn, target, newRdn, delOldRdn);
            }
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind((Name)new LdapDN(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        LdapDN target = this.buildTarget(name);
        if (this.nexusProxy.hasEntry(new EntryOperationContext(target))) {
            this.doDeleteOperation(target);
        }
        this.bind(name, obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind((Name)new LdapDN(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.doDeleteOperation(this.buildTarget(name));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (StringTools.isEmpty((String)name)) {
            return this.lookup((Name)LdapDN.EMPTY_LDAPDN);
        }
        return this.lookup((Name)new LdapDN(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object obj;
        LdapDN target = this.buildTarget(name);
        Attributes attributes = null;
        attributes = name.size() == 0 ? this.doGetRootDSEOperation(target) : this.doLookupOperation(target);
        try {
            obj = DirectoryManager.getObjectInstance(null, name, this, this.env, attributes);
        }
        catch (Exception e) {
            String msg = "Failed to create an object for " + target;
            msg = msg + " using object factories within the context's environment.";
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        if (obj != null) {
            return obj;
        }
        if (attributes.get("javaClassName") != null) {
            return JavaLdapSupport.deserialize(attributes);
        }
        return new ServerLdapContext(this.service, this.principal, target);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new NameParser(){

            public Name parse(String name) throws NamingException {
                return new LdapDN(name);
            }
        };
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParser(){

            public Name parse(String name) throws NamingException {
                return new LdapDN(name);
            }
        };
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list((Name)new LdapDN(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.doListOperation(this.buildTarget(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings((Name)new LdapDN(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        LdapDN base = this.buildTarget(name);
        PresenceNode filter = new PresenceNode("objectClass");
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        return this.doSearchOperation(base, this.getEnvironment(), (ExprNode)filter, ctls);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName((Name)new LdapDN(name), (Name)new LdapDN(prefix)).toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (prefix == null || prefix.size() == 0) {
            return name;
        }
        LdapDN fqn = this.buildTarget(name);
        String head = prefix.get(0);
        while (fqn.size() > 0) {
            if (fqn.get(0).equalsIgnoreCase(head)) {
                return fqn;
            }
            fqn.remove(0);
        }
        String msg = "The prefix '" + prefix + "' is not an ancestor of this ";
        msg = msg + "entry '" + this.dn + "'";
        throw new NamingException(msg);
    }

    @Override
    public void addNamingListener(Name name, int scope, NamingListener namingListener) throws NamingException {
        PresenceNode filter = new PresenceNode("objectClass");
        SearchControls controls = new SearchControls();
        controls.setSearchScope(scope);
        ((PartitionNexusProxy)this.nexusProxy).addNamingListener(this, (Name)this.buildTarget(name), (ExprNode)filter, controls, namingListener);
        this.listeners.add(namingListener);
    }

    @Override
    public void addNamingListener(String name, int scope, NamingListener namingListener) throws NamingException {
        this.addNamingListener((Name)new LdapDN(name), scope, namingListener);
    }

    @Override
    public void removeNamingListener(NamingListener namingListener) throws NamingException {
        ((PartitionNexusProxy)this.nexusProxy).removeNamingListener(this, namingListener);
        this.listeners.remove(namingListener);
    }

    @Override
    public boolean targetMustExist() throws NamingException {
        return false;
    }

    protected Set getListeners() {
        return this.listeners;
    }

    LdapDN buildTarget(Name relativeName) throws InvalidNameException {
        LdapDN target = (LdapDN)this.dn.clone();
        target.addAllNormalized(target.size(), relativeName);
        return target;
    }
}

