/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;

public class TabActionsSelection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TabActionsSelection.class);
    protected Map<String, Action> currentTabActions = new LinkedHashMap<String, Action>();

    public Action getCurrentTabAction(String category) {
        if (this.currentTabActions.containsKey(category)) {
            return this.currentTabActions.get(category);
        }
        return null;
    }

    public void setCurrentTabAction(String category, Action tabAction) {
        if (category == null) {
            return;
        }
        if (tabAction != null) {
            String[] actionCategories = tabAction.getCategories();
            if (actionCategories != null) {
                boolean categoryFound = false;
                for (String actionCategory : actionCategories) {
                    if (!category.equals(actionCategory)) continue;
                    categoryFound = true;
                    Action oldAction = this.currentTabActions.get(category);
                    this.currentTabActions.put(category, tabAction);
                    this.raiseEventOnCurrentTabSelected(category, tabAction.getId());
                    if (oldAction == null || !oldAction.getId().equals(tabAction.getId())) {
                        this.raiseEventOnCurrentTabChange(category, tabAction.getId());
                    }
                    if (oldAction == null) break;
                    this.resetCurrentTabs(TabActionsSelection.getSubTabCategory(oldAction.getId()));
                    break;
                }
                if (!categoryFound) {
                    log.error((Object)String.format("Cannot set current action '%s' for category '%s' as this action does not hold the given category.", tabAction.getId(), category));
                }
            }
        } else {
            this.resetCurrentTabs(category);
        }
    }

    public String getCurrentTabId(String category) {
        Action action = this.getCurrentTabAction(category);
        if (action != null) {
            return action.getId();
        }
        return null;
    }

    public void setCurrentTabId(ActionManager actionManager, ActionContext actionContext, String category, String tabId, String ... subTabIds) {
        boolean set = false;
        if (tabId != null && !"".equals(tabId)) {
            if (actionManager.isEnabled(tabId, actionContext)) {
                Action action = actionManager.getAction(tabId);
                this.setCurrentTabAction(category, action);
                if (subTabIds != null && subTabIds.length > 0) {
                    String newTabId = subTabIds[0];
                    String[] newSubTabsIds = new String[subTabIds.length - 1];
                    System.arraycopy(subTabIds, 1, newSubTabsIds, 0, subTabIds.length - 1);
                    this.setCurrentTabId(actionManager, actionContext, TabActionsSelection.getSubTabCategory(tabId), newTabId, newSubTabsIds);
                }
                set = true;
            } else if (actionManager.getAction(tabId) != null) {
                log.warn((Object)String.format("Cannot set current tab with id '%s': action is not enabled.", tabId));
            } else {
                log.error((Object)String.format("Cannot set current tab with id '%s': action does not exist.", tabId));
            }
        }
        if (!set && (tabId == null || "".equals(tabId))) {
            this.resetCurrentTabs(category);
        }
    }

    public String getCurrentTabIds() {
        StringBuffer builder = new StringBuffer();
        boolean first = true;
        LinkedHashMap actionsToEncode = new LinkedHashMap();
        HashMap<String, String> subTabToCategories = new HashMap<String, String>();
        for (Map.Entry<String, Action> entry : this.currentTabActions.entrySet()) {
            String category = entry.getKey();
            Action action = entry.getValue();
            subTabToCategories.put(TabActionsSelection.getSubTabCategory(action.getId()), category);
            if (subTabToCategories.containsKey(category)) {
                ((List)actionsToEncode.get(subTabToCategories.get(category))).add(action);
                continue;
            }
            ArrayList<Action> actionsList = new ArrayList<Action>();
            actionsList.add(action);
            actionsToEncode.put(category, actionsList);
        }
        for (Map.Entry<String, Object> entry : actionsToEncode.entrySet()) {
            String encodedActions = this.encodeActions(entry.getKey(), (List)entry.getValue());
            if (encodedActions == null) continue;
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(encodedActions);
        }
        return builder.toString();
    }

    public void setCurrentTabIds(ActionManager actionManager, ActionContext actionContext, String tabIds) {
        if (tabIds == null) {
            return;
        }
        String[] encodedActions = tabIds.split(",");
        if (encodedActions != null && encodedActions.length != 0) {
            for (String encodedAction : encodedActions) {
                String category;
                if (":".equals(encodedAction = encodedAction.trim())) {
                    this.resetCurrentTabs("VIEW_ACTION_LIST");
                    continue;
                }
                String[] actionInfo = encodedAction.split(":");
                if (actionInfo != null && actionInfo.length == 1) {
                    if (encodedAction.startsWith(":")) {
                        this.setCurrentTabId(actionManager, actionContext, "VIEW_ACTION_LIST", actionInfo[0], new String[0]);
                        continue;
                    }
                    category = actionInfo[0];
                    if ("*".equals(category)) {
                        this.resetCurrentTabs();
                        continue;
                    }
                    this.resetCurrentTabs(category);
                    continue;
                }
                if (actionInfo != null && actionInfo.length > 1) {
                    category = actionInfo[0];
                    String actionId = actionInfo[1];
                    String[] subTabsIds = new String[actionInfo.length - 2];
                    System.arraycopy(actionInfo, 2, subTabsIds, 0, actionInfo.length - 2);
                    if (category == null || category.isEmpty()) {
                        category = "VIEW_ACTION_LIST";
                    }
                    this.setCurrentTabId(actionManager, actionContext, category, actionId, subTabsIds);
                    continue;
                }
                log.error((Object)String.format("Cannot set current tab from given encoded action: '%s'", encodedAction));
            }
        }
    }

    public void resetCurrentTabs() {
        Set<String> categories = this.currentTabActions.keySet();
        this.currentTabActions.clear();
        for (String category : categories) {
            this.raiseEventOnCurrentTabSelected(category, null);
            this.raiseEventOnCurrentTabChange(category, null);
        }
    }

    public void resetCurrentTabs(String category) {
        if (this.currentTabActions.containsKey(category)) {
            Action action = this.currentTabActions.get(category);
            this.currentTabActions.remove(category);
            this.raiseEventOnCurrentTabSelected(category, null);
            this.raiseEventOnCurrentTabChange(category, null);
            if (action != null) {
                this.resetCurrentTabs(TabActionsSelection.getSubTabCategory(action.getId()));
            }
        }
    }

    protected String encodeActions(String category, List<Action> actions) {
        if (actions == null || actions.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("VIEW_ACTION_LIST".equals(category) ? "" : category);
        for (int i = 0; i < actions.size(); ++i) {
            builder.append(":" + actions.get(i).getId());
        }
        return builder.toString();
    }

    public static String getSubTabCategory(String parentActionId) {
        if (parentActionId == null) {
            return null;
        }
        return parentActionId + "_sub_tab";
    }

    protected void raiseEventOnCurrentTabChange(String category, String tabId) {
        if (Events.exists()) {
            Events.instance().raiseEvent("currentTabChanged", new Object[]{category, tabId});
            Events.instance().raiseEvent("currentTabChanged_" + category, new Object[]{category, tabId});
        }
    }

    protected void raiseEventOnCurrentTabSelected(String category, String tabId) {
        if (Events.exists()) {
            Events.instance().raiseEvent("currentTabSelected", new Object[]{category, tabId});
            Events.instance().raiseEvent("currentTabSelected_" + category, new Object[]{category, tabId});
        }
    }
}

