/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.file;

import java.io.IOException;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.ui.web.component.file.UIInputFile;
import org.nuxeo.ecm.platform.ui.web.component.file.UIOutputFileCommandLink;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.runtime.api.Framework;

public class UIOutputFile
extends UIOutput
implements NamingContainer {
    public static final String COMPONENT_TYPE = UIOutputFile.class.getName();
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    private static final String DOWNLOAD_FACET_NAME = "download";
    private static final String CONVERT_PDF_FACET_NAME = "convertToPdf";
    private static final String EDITONLINE_FACET_NAME = "editOnline";
    private String filename;
    private MethodExpression convertAction;
    private MethodExpression editOnlineAction;
    private Boolean editOnlineActionRendered;
    private Boolean queryParent;
    private String separator = " | ";
    private String downloadLabel;
    private Boolean iconRendered;

    public UIOutputFile() {
        ComponentUtils.initiateSubComponent((UIComponent)this, DOWNLOAD_FACET_NAME, (UIComponent)new UIOutputFileCommandLink());
        ComponentUtils.initiateSubComponent((UIComponent)this, CONVERT_PDF_FACET_NAME, (UIComponent)new HtmlCommandLink());
        ComponentUtils.initiateSubComponent((UIComponent)this, EDITONLINE_FACET_NAME, (UIComponent)new HtmlCommandLink());
    }

    public String getRendererType() {
        return null;
    }

    public Object getValue() {
        UIComponent parent;
        if (this.getQueryParent().booleanValue() && (parent = this.getParent()) instanceof UIInputFile) {
            UIInputFile inputFile = (UIInputFile)parent;
            return inputFile.getCurrentBlob();
        }
        return super.getValue();
    }

    public String getFilename() {
        UIComponent parent;
        if (this.getQueryParent().booleanValue() && (parent = this.getParent()) instanceof UIInputFile) {
            UIInputFile inputFile = (UIInputFile)parent;
            return inputFile.getCurrentFilename();
        }
        if (this.filename != null) {
            return this.filename;
        }
        ValueExpression ve = this.getValueExpression("filename");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public MethodExpression getConvertAction() {
        return this.convertAction;
    }

    public void setConvertAction(MethodExpression convertToPdfAction) {
        this.convertAction = convertToPdfAction;
    }

    public MethodExpression getEditOnlineAction() {
        return this.editOnlineAction;
    }

    public void setEditOnlineAction(MethodExpression editOnlineAction) {
        this.editOnlineAction = editOnlineAction;
    }

    public Boolean getEditOnlineActionRendered() {
        if (this.editOnlineActionRendered != null) {
            return this.editOnlineActionRendered;
        }
        ValueExpression ve = this.getValueExpression("editOnlineActionRendered");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return false;
    }

    public void setEditOnlineActionRendered(Boolean editOnlineActionRendered) {
        this.editOnlineActionRendered = editOnlineActionRendered;
    }

    public String getSeparator() {
        if (this.separator != null) {
            return this.separator;
        }
        ValueExpression ve = this.getValueExpression("separator");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public Boolean getQueryParent() {
        if (this.queryParent != null) {
            return this.queryParent;
        }
        ValueExpression ve = this.getValueExpression("queryParent");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return false;
    }

    public void setQueryParent(Boolean queryParent) {
        this.queryParent = queryParent;
    }

    public void setSeparator(String actionsSeparator) {
        this.separator = actionsSeparator;
    }

    public String getDownloadLabel() {
        if (this.downloadLabel != null) {
            return this.downloadLabel;
        }
        ValueExpression ve = this.getValueExpression("downloadLabel");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setDownloadLabel(String downloadLabel) {
        this.downloadLabel = downloadLabel;
    }

    public Boolean getIconRendered() {
        if (this.iconRendered != null) {
            return this.iconRendered;
        }
        ValueExpression ve = this.getValueExpression("iconRendered");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return true;
    }

    public void setIconRendered(Boolean iconRendered) {
        this.iconRendered = iconRendered;
    }

    protected ValueExpression getBlobExpression(FacesContext context) {
        UIComponent parent;
        if (this.getQueryParent().booleanValue() && (parent = this.getParent()) instanceof UIInputFile) {
            UIInputFile inputFile = (UIInputFile)parent;
            ExpressionFactory ef = context.getApplication().getExpressionFactory();
            return ef.createValueExpression((Object)inputFile.getCurrentBlob(), Blob.class);
        }
        Object local = this.getLocalValue();
        if (local != null) {
            ExpressionFactory ef = context.getApplication().getExpressionFactory();
            return ef.createValueExpression(local, Blob.class);
        }
        return this.getValueExpression("value");
    }

    protected ValueExpression getFileNameExpression(FacesContext context) {
        UIComponent parent;
        if (this.getQueryParent().booleanValue() && (parent = this.getParent()) instanceof UIInputFile) {
            UIInputFile inputFile = (UIInputFile)parent;
            ExpressionFactory ef = context.getApplication().getExpressionFactory();
            return ef.createValueExpression((Object)inputFile.getCurrentFilename(), String.class);
        }
        if (this.filename != null) {
            ExpressionFactory ef = context.getApplication().getExpressionFactory();
            return ef.createValueExpression((Object)this.filename, String.class);
        }
        return this.getValueExpression("filename");
    }

    protected String getDownloadLinkValue(FacesContext context, Blob blob, String filename) {
        String linkValue = this.getDownloadLabel();
        linkValue = linkValue == null ? (filename == null || filename.length() == 0 ? ComponentUtils.translate(context, "label.outputFile.download") : filename) : ComponentUtils.translate(context, linkValue);
        return linkValue;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIComponent downloadFacet;
        Object value = this.getValue();
        if (value != null && value instanceof Blob && (downloadFacet = this.getFacet(DOWNLOAD_FACET_NAME)) != null) {
            Blob blob = (Blob)value;
            String filenameSet = this.getFilename();
            UICommand downloadComp = (UICommand)downloadFacet;
            ComponentUtils.hookSubComponent(context, (UIComponent)this, (UIComponent)downloadComp, DOWNLOAD_FACET_NAME);
            downloadComp.setValue((Object)this.getDownloadLinkValue(context, blob, filenameSet));
            downloadComp.setImmediate(true);
            ComponentUtils.copyLinkValues((UIComponent)this, (UIComponent)downloadComp);
            if (this.getIconRendered().booleanValue()) {
                this.encodeFileIcon(context, blob);
            }
            ComponentUtils.encodeComponent(context, (UIComponent)downloadComp);
        }
    }

    public void encodeFileIcon(FacesContext context, Blob blob) throws IOException {
        String iconPath = "";
        try {
            MimetypeRegistry mimeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            MimetypeEntry mimeEntry = mimeService.getMimetypeEntryByMimeType(blob.getMimeType());
            if (mimeEntry != null && mimeEntry.getIconPath() != null) {
                iconPath = "/icons/" + mimeEntry.getIconPath();
            }
        }
        catch (Exception err) {
            // empty catch block
        }
        if (iconPath.length() > 0) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("img", (UIComponent)this);
            String src = context.getApplication().getViewHandler().getResourceURL(context, iconPath);
            writer.writeURIAttribute("src", (Object)context.getExternalContext().encodeResourceURL(src), null);
            writer.writeAttribute("alt", (Object)blob.getMimeType(), null);
            writer.endElement("img");
            writer.write("&#x0020;");
            writer.flush();
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.filename, this.convertAction, this.editOnlineAction, this.editOnlineActionRendered, this.queryParent};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.filename = (String)values[1];
        this.convertAction = (MethodExpression)values[2];
        this.editOnlineAction = (MethodExpression)values[3];
        this.editOnlineActionRendered = (Boolean)values[4];
        this.queryParent = (Boolean)values[5];
    }
}

