/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.model.impl;

import javax.faces.event.ValueChangeEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelRow;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowEvent;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;

public class SelectDataModelRowImpl
implements SelectDataModelRow {
    private final Log log = LogFactory.getLog(SelectDataModelImpl.class);
    private final SelectDataModel model;
    private Boolean selected;
    private Object data;

    public SelectDataModelRowImpl(SelectDataModel model, Boolean selected, Object data) {
        this.model = model;
        this.selected = selected;
        this.data = data;
    }

    public SelectDataModel getSelectModel() {
        return this.model;
    }

    public void selectionChanged(ValueChangeEvent event) {
        if (this.model == null) {
            this.log.error((Object)"Could not send selection event: SelectModel is null");
            return;
        }
        Object newValue = event.getNewValue();
        Object oldValue = event.getOldValue();
        if (newValue instanceof Boolean && oldValue instanceof Boolean && !newValue.equals(oldValue)) {
            Boolean selection = (Boolean)newValue;
            SelectDataModelRowEvent selectEvent = new SelectDataModelRowEvent((SelectDataModelRow)this, selection, this.data);
            for (SelectDataModelListener listener : this.model.getSelectModelListeners()) {
                Object seamComponent = SeamComponentCallHelper.getSeamComponentByRef(listener);
                if (seamComponent == null) {
                    listener.processSelectRowEvent(selectEvent);
                    continue;
                }
                SelectDataModelListener wrappedListener = (SelectDataModelListener)seamComponent;
                wrappedListener.processSelectRowEvent(selectEvent);
            }
        }
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

