/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.model.impl;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelRow;
import org.nuxeo.ecm.platform.ui.web.model.impl.AbstractSortableSelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDocumentDataModelRowComparator;

public class SortableSelectDocumentDataModelImpl
extends AbstractSortableSelectDataModel {
    private static final long serialVersionUID = 8096546666470084522L;
    private static final Log log = LogFactory.getLog(SortableSelectDocumentDataModelImpl.class);

    public SortableSelectDocumentDataModelImpl(String name, List data, List selectedData, String defaultSortColumn) {
        super(name, data, selectedData, defaultSortColumn);
    }

    @Override
    public List<SelectDataModelRow> getRows() {
        this.sort(this.sort, this.ascending);
        return super.getRows();
    }

    @Override
    public boolean isDefaultAscending(String sortColumn) {
        return false;
    }

    @Override
    public void sort(String column, boolean ascending) {
        if (column != null) {
            String[] s = column.split(":");
            String schemaName = null;
            String fieldName = null;
            try {
                schemaName = s[0];
                fieldName = s[1];
            }
            catch (ArrayIndexOutOfBoundsException err) {
                log.error((Object)("Invalid column name '" + column + "', should follow format 'schemaName:fieldName'"));
            }
            if (schemaName == null || fieldName == null) {
                log.error((Object)"Could not sort rows");
            } else {
                Collections.sort(this.rows, new SelectDocumentDataModelRowComparator(schemaName, fieldName, ascending));
            }
        } else {
            log.error((Object)"Null column received");
        }
    }
}

