/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.handler;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.ui.web.binding.MetaValueExpression;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasTagHandler;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapper;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;

public class SetTagHandler
extends AliasTagHandler {
    protected final TagAttribute var = this.getRequiredAttribute("var");
    protected final TagAttribute value = this.getAttribute("value");
    protected final TagAttribute resolveTwice = this.getAttribute("resolveTwice");
    protected final TagAttribute blockPatterns = this.getAttribute("blockPatterns");

    public SetTagHandler(TagConfig config) {
        super(config, null);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        String blocked;
        ValueExpression ve;
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        String id = ctx.generateUniqueId(this.tagId);
        boolean cacheValue = false;
        if (this.cache != null) {
            cacheValue = this.cache.getBoolean(ctx);
        }
        boolean resolveTwiceBool = false;
        if (this.resolveTwice != null) {
            resolveTwiceBool = this.resolveTwice.getBoolean(ctx);
        }
        String varStr = this.var.getValue(ctx);
        if (cacheValue) {
            Object res = this.value.getObject(ctx);
            if (resolveTwiceBool && res instanceof String && ComponentTagUtils.isValueReference((String)res)) {
                ve = ctx.getExpressionFactory().createValueExpression((ELContext)ctx, (String)res, Object.class);
                res = ve.getValue((ELContext)ctx);
            }
            ve = ctx.getExpressionFactory().createValueExpression(res, Object.class);
        } else {
            ve = this.value.getValueExpression(ctx, Object.class);
            if (resolveTwiceBool) {
                ve = new MetaValueExpression(ve);
            }
        }
        AliasVariableMapper target = new AliasVariableMapper(id);
        target.setVariable(varStr, ve);
        if (this.blockPatterns != null && !StringUtils.isEmpty((String)(blocked = this.blockPatterns.getValue(ctx)))) {
            target.setBlockedPatterns(this.resolveBlockPatterns(blocked));
        }
        this.apply(ctx, parent, target);
    }

    protected List<String> resolveBlockPatterns(String value) {
        ArrayList<String> res = new ArrayList<String>();
        if (value != null) {
            if (value.contains(",")) {
                String[] names;
                for (String name : names = value.split(",")) {
                    if (StringUtils.isBlank((String)name)) continue;
                    name = name.trim();
                    res.add(name);
                }
            } else {
                value = value.trim();
                res.add(value);
            }
        }
        return res;
    }
}

