/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.jsf;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.util.FacesAPI;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import org.nuxeo.ecm.platform.ui.web.binding.MethodValueExpression;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;

public class GenericValueHolderRule
extends MetaRule {
    public static final GenericValueHolderRule Instance = new GenericValueHolderRule();

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(ValueHolder.class)) {
            if ("converter".equals(name)) {
                if (attribute.isLiteral()) {
                    return new LiteralConverterMetadata(attribute.getValue());
                }
                if (FacesAPI.getComponentVersion((Class)meta.getTargetClass()) >= 12) {
                    return new DynamicConverterMetadata2(attribute);
                }
                return new DynamicConverterMetadata(attribute);
            }
            if ("genericValue".equals(name)) {
                if (attribute.isLiteral()) {
                    return new LiteralValueMetadata(attribute.getValue());
                }
                String value = attribute.getValue();
                if (ComponentTagUtils.isMethodReference(value)) {
                    return new MethodValueBindingMetadata(attribute);
                }
                if (FacesAPI.getComponentVersion((Class)meta.getTargetClass()) >= 12) {
                    return new DynamicValueExpressionMetadata(attribute);
                }
                return new DynamicValueBindingMetadata(attribute);
            }
        }
        return null;
    }

    static final class MethodValueBindingMetadata
    extends Metadata {
        private final TagAttribute attr;

        MethodValueBindingMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            Class[] paramTypesClasses = new Class[]{};
            Class<Object> returnType = Object.class;
            MethodExpression meth = this.attr.getMethodExpression(ctx, returnType, paramTypesClasses);
            MethodValueExpression ve = new MethodValueExpression(ctx.getFunctionMapper(), ctx.getVariableMapper(), meth, paramTypesClasses);
            ((UIComponent)instance).setValueBinding("value", (ValueBinding)new LegacyValueBinding((ValueExpression)ve));
        }
    }

    static final class DynamicValueBindingMetadata
    extends Metadata {
        private final TagAttribute attr;

        DynamicValueBindingMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueBinding("value", (ValueBinding)new LegacyValueBinding(this.attr.getValueExpression(ctx, Object.class)));
        }
    }

    static final class DynamicValueExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        DynamicValueExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueExpression("value", this.attr.getValueExpression(ctx, Object.class));
        }
    }

    static final class LiteralValueMetadata
    extends Metadata {
        private final String value;

        LiteralValueMetadata(String value) {
            this.value = value;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((ValueHolder)instance).setValue((Object)this.value);
        }
    }

    static final class DynamicConverterMetadata2
    extends Metadata {
        private final TagAttribute attr;

        DynamicConverterMetadata2(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueExpression("converter", this.attr.getValueExpression(ctx, Converter.class));
        }
    }

    static final class DynamicConverterMetadata
    extends Metadata {
        private final TagAttribute attr;

        DynamicConverterMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((UIComponent)instance).setValueBinding("converter", (ValueBinding)new LegacyValueBinding(this.attr.getValueExpression(ctx, Converter.class)));
        }
    }

    static final class LiteralConverterMetadata
    extends Metadata {
        private final String converterId;

        LiteralConverterMetadata(String converterId) {
            this.converterId = converterId;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((ValueHolder)instance).setConverter(ctx.getFacesContext().getApplication().createConverter(this.converterId));
        }
    }
}

