/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util.files;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class FileUtils {
    private static final Log log = LogFactory.getLog(FileUtils.class);

    private FileUtils() {
    }

    public static Blob createSerializableBlob(InputStream file, String filename, String mimeType) {
        Blob blob = null;
        try {
            blob = StreamingBlob.createFromStream((InputStream)file, (String)mimeType).persist();
            if (filename != null) {
                filename = FileUtils.getCleanFileName(filename);
            }
            blob.setFilename(filename);
            MimetypeRegistry mimeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            String detectedMimeType = mimeService.getMimetypeFromFilenameAndBlobWithDefault(filename, blob, null);
            if (detectedMimeType == null) {
                detectedMimeType = mimeType != null ? mimeType : "application/octet-stream";
            }
            blob.setMimeType(detectedMimeType);
        }
        catch (MimetypeDetectionException e) {
            log.error((Object)String.format("could not fetch mimetype for file %s", filename), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return blob;
    }

    public static String getCleanFileName(String filename) {
        int lastUnixSeparator;
        String res = null;
        int lastWinSeparator = filename.lastIndexOf(92);
        int lastSeparator = Math.max(lastWinSeparator, lastUnixSeparator = filename.lastIndexOf(47));
        res = lastSeparator != -1 ? filename.substring(lastSeparator + 1, filename.length()) : filename;
        return res;
    }
}

