/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObject;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoSession;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;

public abstract class NuxeoFileableObject
extends NuxeoObject
implements FileableCmisObject {
    public NuxeoFileableObject(NuxeoSession session, NuxeoObjectData data, ObjectType type) {
        super(session, data, type);
    }

    public List<Folder> getParents(OperationContext context) {
        try {
            CoreSession coreSession = this.data.doc.getCoreSession();
            DocumentModel parent = coreSession.getParentDocument((DocumentRef)new IdRef(this.getId()));
            if (parent == null || this.service.isFilteredOut(parent)) {
                return Collections.emptyList();
            }
            Folder folder = (Folder)this.session.getObject(parent, this.session.getDefaultContext());
            return Collections.singletonList(folder);
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public List<Folder> getParents() {
        return this.getParents(null);
    }

    public List<String> getPaths() {
        return Collections.singletonList(this.data.doc.getPathAsString());
    }

    public void addToFolder(ObjectId folderId, boolean allVersions) {
        throw new UnsupportedOperationException("Multi-filing not supported");
    }

    public void removeFromFolder(ObjectId folderId) {
        this.service.removeObjectFromFolder(this.getRepositoryId(), this.getId(), folderId == null ? null : folderId.getId(), null);
    }

    public NuxeoFileableObject move(ObjectId sourceFolder, ObjectId targetFolder, OperationContext context) {
        Holder objectIdHolder = new Holder((Object)this.getId());
        if (sourceFolder == null) {
            throw new CmisInvalidArgumentException("Missing source folder");
        }
        if (targetFolder == null) {
            throw new CmisInvalidArgumentException("Missing target folder");
        }
        this.service.moveObject(this.getRepositoryId(), (Holder<String>)objectIdHolder, targetFolder.getId(), sourceFolder.getId(), null);
        return this;
    }

    public NuxeoFileableObject move(ObjectId sourceFolder, ObjectId targetFolder) {
        return this.move(sourceFolder, targetFolder, null);
    }
}

