/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.TransientDocument;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoDocument;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObject;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoTransientFileableObject;

public class NuxeoTransientDocument
extends NuxeoTransientFileableObject
implements TransientDocument {
    protected ContentStream contentStream;
    protected boolean contentStreamOverwrite;
    protected boolean contentStreamUpdated;

    public NuxeoTransientDocument(NuxeoObject object) {
        super(object);
    }

    @Override
    public boolean isModified() {
        return this.contentStreamUpdated || super.isModified();
    }

    public void deleteAllVersions() {
        this.delete(true);
    }

    public ContentStream getContentStream() {
        if (this.contentStreamUpdated) {
            return this.contentStream;
        }
        return ((NuxeoDocument)this.object).getContentStream();
    }

    public ContentStream getContentStream(String streamId) {
        if (streamId == null) {
            return this.getContentStream();
        }
        return ((NuxeoDocument)this.object).getContentStream(streamId);
    }

    public void setContentStream(ContentStream contentStream, boolean overwrite) {
        this.contentStream = contentStream;
        this.contentStreamOverwrite = overwrite;
        this.contentStreamUpdated = true;
    }

    public void deleteContentStream() {
        this.contentStream = null;
        this.contentStreamUpdated = true;
    }

    public Document getObjectOfLatestVersion(boolean major) {
        return ((NuxeoDocument)this.object).getObjectOfLatestVersion(major);
    }

    public Document getObjectOfLatestVersion(boolean major, OperationContext context) {
        return ((NuxeoDocument)this.object).getObjectOfLatestVersion(major, context);
    }

    public List<Document> getAllVersions() {
        return ((NuxeoDocument)this.object).getAllVersions();
    }

    public List<Document> getAllVersions(OperationContext context) {
        return ((NuxeoDocument)this.object).getAllVersions(context);
    }

    public Document copy(ObjectId targetFolderId) {
        return ((NuxeoDocument)this.object).copy(targetFolderId);
    }

    public Document copy(ObjectId targetFolderId, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addACEs, List<Ace> removeACEs, OperationContext context) {
        return ((NuxeoDocument)this.object).copy(targetFolderId, (Map)properties, versioningState, (List)policies, (List)addACEs, (List)removeACEs, context);
    }

    public Boolean isImmutable() {
        return ((NuxeoDocument)this.object).isImmutable();
    }

    public Boolean isLatestVersion() {
        return ((NuxeoDocument)this.object).isLatestVersion();
    }

    public Boolean isMajorVersion() {
        return ((NuxeoDocument)this.object).isMajorVersion();
    }

    public Boolean isLatestMajorVersion() {
        return ((NuxeoDocument)this.object).isLatestMajorVersion();
    }

    public String getVersionLabel() {
        return ((NuxeoDocument)this.object).getVersionLabel();
    }

    public String getVersionSeriesId() {
        return ((NuxeoDocument)this.object).getVersionSeriesId();
    }

    public Boolean isVersionSeriesCheckedOut() {
        return ((NuxeoDocument)this.object).isVersionSeriesCheckedOut();
    }

    public String getVersionSeriesCheckedOutBy() {
        return ((NuxeoDocument)this.object).getVersionSeriesCheckedOutBy();
    }

    public String getVersionSeriesCheckedOutId() {
        return ((NuxeoDocument)this.object).getVersionSeriesCheckedOutId();
    }

    public String getCheckinComment() {
        return ((NuxeoDocument)this.object).getCheckinComment();
    }

    public long getContentStreamLength() {
        if (this.contentStreamUpdated) {
            return this.contentStream == null ? -1L : this.contentStream.getLength();
        }
        return ((NuxeoDocument)this.object).getContentStreamLength();
    }

    public String getContentStreamMimeType() {
        if (this.contentStreamUpdated) {
            return this.contentStream == null ? null : this.contentStream.getMimeType();
        }
        return ((NuxeoDocument)this.object).getContentStreamMimeType();
    }

    public String getContentStreamFileName() {
        if (this.contentStreamUpdated) {
            return this.contentStream == null ? null : this.contentStream.getFileName();
        }
        return ((NuxeoDocument)this.object).getContentStreamFileName();
    }

    public String getContentStreamId() {
        return ((NuxeoDocument)this.object).getContentStreamId();
    }

    public ObjectId checkIn(boolean major, String checkinComment) {
        ObjectId objectId = ((NuxeoDocument)this.object).checkIn(major, this.properties, this.contentStream, checkinComment);
        this.reset();
        return objectId;
    }

    @Override
    public ObjectId save() {
        if (this.saveDeletes()) {
            this.reset();
            return null;
        }
        if (this.contentStreamUpdated) {
            ((NuxeoDocument)this.object).setContentStream(this.contentStream, this.contentStreamOverwrite);
        }
        return super.save();
    }

    @Override
    public void reset() {
        super.reset();
        this.contentStream = null;
        this.contentStreamOverwrite = false;
        this.contentStreamUpdated = false;
    }
}

