/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.client.runtime.PropertyImpl;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObject;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyData;

public class NuxeoTransientObject
implements TransientCmisObject {
    protected final NuxeoObject object;
    protected Map<String, Object> properties;
    protected Boolean markedForDeleteAllVersions;

    public NuxeoTransientObject(NuxeoObject object) {
        this.object = object;
        this.properties = new HashMap<String, Object>();
    }

    public NuxeoObject getCmisObject() {
        return this.object;
    }

    public String getId() {
        return this.object.getId();
    }

    public ObjectType getType() {
        return this.object.getType();
    }

    public BaseTypeId getBaseTypeId() {
        return this.object.getBaseTypeId();
    }

    public ObjectType getBaseType() {
        return this.object.getBaseType();
    }

    public String getName() {
        return (String)this.getPropertyValue("cmis:name");
    }

    public String getChangeToken() {
        return (String)this.getPropertyValue("cmis:changeToken");
    }

    public String getCreatedBy() {
        return (String)this.getPropertyValue("cmis:createdBy");
    }

    public GregorianCalendar getCreationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:creationDate");
    }

    public GregorianCalendar getLastModificationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:lastModificationDate");
    }

    public String getLastModifiedBy() {
        return (String)this.getPropertyValue("cmis:lastModifiedBy");
    }

    public AllowableActions getAllowableActions() {
        return this.object.getAllowableActions();
    }

    public List<Policy> getPolicies() {
        return this.object.getPolicies();
    }

    public List<Relationship> getRelationships() {
        return this.object.getRelationships();
    }

    public List<Rendition> getRenditions() {
        return this.object.getRenditions();
    }

    public void addAce(String principalId, List<String> permissions, AclPropagation aclPropagation) {
        throw new CmisNotSupportedException();
    }

    public void removeAce(String principalId, List<String> permissions, AclPropagation aclPropagation) {
        throw new CmisNotSupportedException();
    }

    public Acl getOriginalAcl() {
        throw new CmisNotSupportedException();
    }

    public void applyPolicy(Policy ... policyIds) {
        throw new CmisNotSupportedException();
    }

    public void removePolicy(Policy ... policyIds) {
        throw new CmisNotSupportedException();
    }

    public List<CmisExtensionElement> getInputExtensions(ExtensionLevel level) {
        return Collections.emptyList();
    }

    public List<CmisExtensionElement> getOutputExtensions(ExtensionLevel level) {
        return Collections.emptyList();
    }

    public void setOutputExtensions(ExtensionLevel level, List<CmisExtensionElement> extensions) {
        throw new CmisNotSupportedException();
    }

    public void delete(boolean allVersions) {
        this.markedForDeleteAllVersions = allVersions;
    }

    public void setName(String name) {
        this.setPropertyValue("cmis:name", name);
    }

    public <T> T getPropertyValue(String id) {
        if (this.properties.containsKey(id)) {
            return (T)this.properties.get(id);
        }
        return this.object.getPropertyValue(id);
    }

    public <T> Property<T> getProperty(String id) {
        if (this.properties.containsKey(id)) {
            Object value = this.properties.get(id);
            PropertyDefinition pd = (PropertyDefinition)this.getType().getPropertyDefinitions().get(id);
            List<Object> values = value == null ? Collections.emptyList() : (value instanceof List ? (List<Object>)value : Collections.singletonList(value));
            return new PropertyImpl(pd, values);
        }
        return this.object.getProperty(id);
    }

    public List<Property<?>> getProperties() {
        ArrayList list = new ArrayList();
        HashSet<String> todo = new HashSet<String>(this.properties.keySet());
        for (Object p : this.object.getProperties()) {
            String id = p.getId();
            if (this.properties.containsKey(id)) {
                p = this.getProperty(id);
                todo.remove(id);
            }
            list.add((Property<?>)p);
        }
        for (String id : todo) {
            list.add(this.getProperty(id));
        }
        return list;
    }

    public void setPropertyValue(String id, Object value) {
        PropertyDefinition pd = (PropertyDefinition)this.getType().getPropertyDefinitions().get(id);
        if (pd == null) {
            throw new CmisInvalidArgumentException("Unknown property: " + id);
        }
        if (pd.getUpdatability() == Updatability.READONLY) {
            throw new CmisInvalidArgumentException("Property is read-only: " + id);
        }
        NuxeoPropertyData.validateCMISValue(value, pd);
        this.properties.put(id, value);
    }

    public boolean isMarkedForDelete() {
        return this.markedForDeleteAllVersions != null;
    }

    public boolean isModified() {
        return this.markedForDeleteAllVersions != null || !this.properties.isEmpty();
    }

    protected boolean saveDeletes() {
        if (this.markedForDeleteAllVersions != null) {
            this.object.service.deleteObject(this.object.getRepositoryId(), this.getId(), this.markedForDeleteAllVersions, null);
            return true;
        }
        return false;
    }

    public ObjectId save() {
        if (this.saveDeletes()) {
            this.reset();
            return null;
        }
        this.object.updateProperties(this.properties);
        this.reset();
        return this;
    }

    public void reset() {
        this.properties.clear();
        this.markedForDeleteAllVersions = null;
    }

    public void refreshAndReset() {
        this.object.refresh();
        this.reset();
    }
}

