/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import com.sun.star.uno.RuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.document.DefaultDocumentFormatRegistry;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.artofsolving.jodconverter.document.DocumentFormatRegistry;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.extension.ExternalConverter;
import org.nuxeo.ecm.platform.convert.ooomanager.OOoManagerService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;

public class JODBasedConverter
implements ExternalConverter {
    protected static final String TMP_PATH_PARAMETER = "TmpDirectory";
    private static final Log log = LogFactory.getLog(JODBasedConverter.class);
    private static final DocumentFormatRegistry formatRegistry = new DefaultDocumentFormatRegistry();
    public static final String PDFA1_PARAM = "PDF/A-1";
    public static final String UPDATE_INDEX_PARAM = "updateDocumentIndex";
    protected static final Map<DocumentFamily, String> PDF_FILTER_NAMES = new HashMap<DocumentFamily, String>();
    protected ConverterDescriptor descriptor;

    public JODBasedConverter() {
        PDF_FILTER_NAMES.put(DocumentFamily.TEXT, "writer_pdf_Export");
        PDF_FILTER_NAMES.put(DocumentFamily.SPREADSHEET, "calc_pdf_Export");
        PDF_FILTER_NAMES.put(DocumentFamily.PRESENTATION, "impress_pdf_Export");
        PDF_FILTER_NAMES.put(DocumentFamily.DRAWING, "draw_pdf_Export");
    }

    protected String getDestinationMimeType() {
        return this.descriptor.getDestinationMimeType();
    }

    protected DocumentFormat getDestinationFormat(DocumentFormat sourceFormat, boolean pdfa1) {
        DocumentFormat destinationFormat;
        boolean html2pdf;
        String mimeType = this.getDestinationMimeType();
        boolean topdf = "application/pdf".equals(mimeType);
        boolean bl = html2pdf = "text/html".equals(sourceFormat.getMediaType()) && topdf;
        if (topdf) {
            destinationFormat = new DocumentFormat(pdfa1 ? PDFA1_PARAM : "PDF", "pdf", "application/pdf");
            HashMap<String, Object> storeProperties = new HashMap<String, Object>();
            DocumentFamily sourceFamily = sourceFormat.getInputFamily();
            String filterName = html2pdf ? "writer_web_pdf_Export" : PDF_FILTER_NAMES.get(sourceFamily);
            storeProperties.put("FilterName", filterName);
            if (pdfa1) {
                HashMap<String, Constable> filterData = new HashMap<String, Constable>();
                filterData.put("SelectPdfVersion", Integer.valueOf(1));
                filterData.put("UseTaggedPDF", Boolean.TRUE);
                storeProperties.put("FilterData", filterData);
            }
            destinationFormat.setStoreProperties(sourceFamily, storeProperties);
        } else {
            destinationFormat = formatRegistry.getFormatByMediaType(mimeType);
        }
        return destinationFormat;
    }

    private static DocumentFormat getSourceFormat(File file) throws Exception {
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetypeStr = mimetypeRegistry.getMimetypeFromFile(file);
        DocumentFormat format = formatRegistry.getFormatByMediaType(mimetypeStr);
        return format;
    }

    private static DocumentFormat getSourceFormat(String mimetype) {
        return formatRegistry.getFormatByMediaType(mimetype);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        boolean pdfa1;
        OfficeDocumentConverter documentConverter;
        Blob inputBlob;
        try {
            inputBlob = blobHolder.getBlob();
            OOoManagerService oooManagerService = (OOoManagerService)Framework.getService(OOoManagerService.class);
            documentConverter = oooManagerService.getDocumentConverter();
        }
        catch (Exception e) {
            throw new ConversionException("Error while getting Blob", e);
        }
        if (inputBlob == null) {
            return null;
        }
        String sourceMimetype = inputBlob.getMimeType();
        boolean bl = pdfa1 = parameters != null && Boolean.TRUE.equals(parameters.get(PDFA1_PARAM));
        if (documentConverter != null) {
            File sourceFile = null;
            File outFile = null;
            File[] files = null;
            try {
                String ext;
                int dotPosition;
                if ("text/html".equals(sourceMimetype)) {
                    inputBlob = this.checkCharsetMeta(inputBlob);
                }
                ext = (dotPosition = (ext = inputBlob.getFilename()).lastIndexOf(46)) == -1 ? ".bin" : ext.substring(dotPosition);
                sourceFile = File.createTempFile("NXJOOoConverterDocumentIn", ext);
                InputStream stream = inputBlob.getStream();
                FileUtils.copyToFile((InputStream)stream, (File)sourceFile);
                DocumentFormat sourceFormat = null;
                if (sourceMimetype != null) {
                    sourceFormat = JODBasedConverter.getSourceFormat(sourceMimetype);
                }
                if (sourceFormat == null) {
                    sourceFormat = JODBasedConverter.getSourceFormat(sourceFile);
                }
                DocumentFormat destinationFormat = this.getDestinationFormat(sourceFormat, pdfa1);
                ArrayList<StreamingBlob> blobs = new ArrayList<StreamingBlob>();
                if (this.descriptor.getDestinationMimeType().equals("text/html")) {
                    String tmpDirPath = this.getTmpDirectory();
                    File myTmpDir = new File(tmpDirPath + "/JODConv_" + System.currentTimeMillis());
                    boolean created = myTmpDir.mkdir();
                    if (!created) {
                        throw new ConversionException("Unable to create temp dir");
                    }
                    outFile = new File(myTmpDir.getAbsolutePath() + "/" + "NXJOOoConverterDocumentOut." + destinationFormat.getExtension());
                    created = outFile.createNewFile();
                    if (!created) {
                        throw new ConversionException("Unable to create temp file");
                    }
                    log.debug((Object)"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
                    log.debug((Object)("Input File = " + outFile.getAbsolutePath()));
                    documentConverter.convert(sourceFile, outFile, destinationFormat, parameters);
                    for (File file : files = myTmpDir.listFiles()) {
                        StreamingBlob blob = StreamingBlob.createFromByteArray((byte[])new FileSource(file).getBytes());
                        blob.setFilename(file.getName());
                        blobs.add(blob);
                        if (!file.getName().equals(outFile.getName())) continue;
                        File indexFile = File.createTempFile("idx-", file.getName());
                        FileUtils.copy((File)file, (File)indexFile);
                        StreamingBlob indexBlob = StreamingBlob.createFromByteArray((byte[])new FileSource(indexFile).getBytes());
                        indexBlob.setFilename("index.html");
                        blobs.add(0, indexBlob);
                        indexFile.delete();
                    }
                } else {
                    outFile = File.createTempFile("NXJOOoConverterDocumentOut", '.' + destinationFormat.getExtension());
                    documentConverter.convert(sourceFile, outFile, destinationFormat, parameters);
                    StreamingBlob blob = StreamingBlob.createFromByteArray((byte[])new FileSource(outFile).getBytes(), (String)this.getDestinationMimeType());
                    blobs.add(blob);
                }
                SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder(blobs);
                return simpleCachableBlobHolder;
            }
            catch (Exception e) {
                log.error((Object)String.format("An error occurred trying to convert a file to from %s to %s: %s", sourceMimetype, this.getDestinationMimeType(), e.getMessage()), (Throwable)e);
                throw new ConversionException("Error in JODConverter", e);
            }
            finally {
                if (sourceFile != null) {
                    sourceFile.delete();
                }
                if (outFile != null) {
                    outFile.delete();
                }
                if (files != null) {
                    for (void var30_34 : files) {
                        if (!var30_34.exists()) continue;
                        var30_34.delete();
                    }
                }
            }
        }
        throw new ConversionException("Could not connect to the remote OpenOffice server");
    }

    public void init(ConverterDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ConverterCheckResult isConverterAvailable() {
        ConverterCheckResult result = new ConverterCheckResult();
        try {
            OOoManagerService oooManagerService = (OOoManagerService)Framework.getService(OOoManagerService.class);
            if (!oooManagerService.isOOoManagerStarted()) {
                result.setAvailable(false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get OOoManagerService");
        }
        return result;
    }

    protected String getTmpDirectory() {
        String tmp = null;
        Map parameters = this.descriptor.getParameters();
        if (parameters != null && parameters.containsKey(TMP_PATH_PARAMETER)) {
            tmp = (String)parameters.get(TMP_PATH_PARAMETER);
        }
        if (tmp == null) {
            tmp = System.getProperty("java.io.tmpdir");
        }
        return tmp;
    }

    protected Blob checkCharsetMeta(Blob inputBlob) throws IOException {
        Pattern charsetMetaPattern;
        Matcher charsetMetaMatcher;
        String charset = inputBlob.getEncoding();
        if (!StringUtils.isEmpty((String)charset) && !(charsetMetaMatcher = (charsetMetaPattern = Pattern.compile(String.format("content=\"text/html;\\s*charset=%s\"", charset))).matcher(inputBlob.getString())).find()) {
            String charsetMetaTag = String.format("<META http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">", charset);
            StringBuilder sb = new StringBuilder(charsetMetaTag);
            sb.append(new String(inputBlob.getByteArray(), charset));
            StringBlob blobWithCharsetMetaTag = new StringBlob(sb.toString(), "text/html", charset);
            blobWithCharsetMetaTag.setFilename(inputBlob.getFilename());
            return blobWithCharsetMetaTag;
        }
        return inputBlob;
    }
}

