/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.util.ErrorMessageUtil;

public abstract class AbstractAntiSamyScanner {
    protected Policy policy;
    protected ArrayList errorMessages = new ArrayList();
    protected ResourceBundle messages;
    protected Locale locale = Locale.getDefault();
    protected boolean isNofollowAnchors = false;
    protected boolean isValidateParamAsEmbed = false;

    public abstract CleanResults scan(String var1, String var2, String var3) throws ScanException;

    public abstract CleanResults getResults();

    public AbstractAntiSamyScanner(Policy policy) {
        this.policy = policy;
        this.initializeErrors();
    }

    public AbstractAntiSamyScanner() throws PolicyException {
        this.policy = Policy.getInstance();
        this.initializeErrors();
    }

    protected void initializeErrors() {
        try {
            this.messages = ResourceBundle.getBundle("AntiSamy", this.locale);
        }
        catch (MissingResourceException mre) {
            this.messages = ResourceBundle.getBundle("AntiSamy", new Locale("en", "US"));
        }
    }

    protected void addError(String errorKey, Object[] objs) {
        this.errorMessages.add(ErrorMessageUtil.getMessage(this.messages, errorKey, objs));
    }
}

