/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.IOException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentTreeIterator;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelReader;

public class DocumentTreeReader
extends DocumentModelReader {
    private DocumentTreeIterator iterator;
    private int pathSegmentsToRemove = 0;

    public DocumentTreeReader(CoreSession session, DocumentModel root, boolean excludeRoot) throws ClientException {
        super(session);
        this.iterator = new DocumentTreeIterator(session, root, excludeRoot);
        this.pathSegmentsToRemove = root.getPath().segmentCount() - (excludeRoot ? 0 : 1);
    }

    public DocumentTreeReader(CoreSession session, DocumentRef root) throws ClientException {
        this(session, session.getDocument(root));
    }

    public DocumentTreeReader(CoreSession session, DocumentModel root) throws ClientException {
        this(session, root, false);
    }

    @Override
    public void close() {
        super.close();
        this.iterator.reset();
        this.iterator = null;
    }

    @Override
    public ExportedDocument read() throws IOException {
        if (this.iterator.hasNext()) {
            DocumentModel docModel = this.iterator.next();
            if (this.pathSegmentsToRemove > 0) {
                return new ExportedDocumentImpl(docModel, docModel.getPath().removeFirstSegments(this.pathSegmentsToRemove), this.inlineBlobs);
            }
            return new ExportedDocumentImpl(docModel, this.inlineBlobs);
        }
        return null;
    }
}

