/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.resource;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import net.java.dev.webdav.core.jaxrs.xml.properties.IsHidden;
import net.java.dev.webdav.jaxrs.xml.elements.Prop;
import net.java.dev.webdav.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.jaxrs.xml.elements.Status;
import net.java.dev.webdav.jaxrs.xml.properties.CreationDate;
import net.java.dev.webdav.jaxrs.xml.properties.DisplayName;
import net.java.dev.webdav.jaxrs.xml.properties.GetContentLength;
import net.java.dev.webdav.jaxrs.xml.properties.GetContentType;
import net.java.dev.webdav.jaxrs.xml.properties.GetLastModified;
import net.java.dev.webdav.jaxrs.xml.properties.ResourceType;
import org.w3c.dom.Element;

public class PropStatBuilderExt {
    private List<Object> properties = new LinkedList<Object>();
    private Response.Status status;
    private Set<String> names = new HashSet<String>();

    public PropStatBuilderExt creationDate(Date dateTime) {
        if (!this.names.contains("creationdate")) {
            CreationDate create = new CreationDate(dateTime);
            this.properties.add(create);
            this.names.add("creationdate");
        }
        return this;
    }

    public PropStatBuilderExt lastModified(Date dateTime) {
        if (!this.names.contains("getlastmodified")) {
            GetLastModified lastModified = new GetLastModified(dateTime);
            this.properties.add(lastModified);
            this.names.add("getlastmodified");
        }
        return this;
    }

    public PropStatBuilderExt contentLength(long length) {
        if (!this.names.contains("getcontentlength")) {
            GetContentLength contentLength = new GetContentLength(length);
            this.properties.add(contentLength);
            this.names.add("getcontentlength");
        }
        return this;
    }

    public PropStatBuilderExt isResource(long length, String mime) {
        if (!this.names.contains("getcontenttype")) {
            GetContentType type = new GetContentType(mime);
            this.properties.add(type);
            this.names.add("getcontenttype");
            GetContentLength contentLength = new GetContentLength(length);
            this.properties.add(contentLength);
            this.names.add("getcontentlength");
        }
        return this;
    }

    public PropStatBuilderExt isCollection() {
        if (!this.names.contains("resourcetype")) {
            ResourceType type = ResourceType.COLLECTION;
            this.properties.add(type);
            this.names.add("resourcetype");
        }
        return this;
    }

    public PropStatBuilderExt displayName(String displayName) {
        if (!this.names.contains("displayname")) {
            DisplayName name = new DisplayName(displayName);
            this.properties.add(name);
            this.names.add("displayname");
        }
        return this;
    }

    public PropStatBuilderExt isHidden(boolean hide) {
        if (!this.names.contains("ishidden")) {
            IsHidden hidden = new IsHidden(hide ? 1 : 0);
            this.properties.add(hidden);
            this.names.add("ishidden");
        }
        return this;
    }

    public PropStat notFound(Prop allprops) {
        boolean empty = true;
        ArrayList notFound = new ArrayList();
        for (Object prop : allprops.getProperties()) {
            Element element;
            String name;
            if (!(prop instanceof Element) || this.names.contains(name = (element = (Element)prop).getLocalName())) continue;
            notFound.add(prop);
            empty = false;
        }
        PropStat stat = null;
        if (!empty) {
            Object[] objects = notFound.toArray(new Object[this.properties.size()]);
            Prop prop = new Prop(objects);
            stat = new PropStat(prop, new Status(Response.Status.NOT_FOUND));
        }
        return stat;
    }

    public PropStatBuilderExt status(Response.Status status) {
        this.status = status;
        return this;
    }

    public PropStat build() {
        Object[] objects = this.properties.toArray(new Object[this.properties.size()]);
        Prop prop = new Prop(objects);
        PropStat stat = new PropStat(prop, new Status(this.status));
        return stat;
    }
}

