/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.el;

import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FieldAdapterManager {
    private static final Log log = LogFactory.getLog(FieldAdapterManager.class);

    private FieldAdapterManager() {
    }

    public static Object getValueForStorage(Object value) {
        if (value instanceof Date) {
            value = FieldAdapterManager.getDateAsCalendar((Date)value);
        } else if (value instanceof Object[]) {
            Object[] array = value;
            Class<?> oldType = array.getClass().getComponentType();
            Class<?> newType = FieldAdapterManager.getComponentTypeForStorage(oldType);
            Object[] newArray = (Object[])Array.newInstance(newType, array.length);
            for (int i = 0; i < array.length; ++i) {
                newArray[i] = FieldAdapterManager.getValueForStorage(array[i]);
            }
            value = newArray;
        } else if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, FieldAdapterManager.getValueForStorage(list.get(i)));
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            Object[] newMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                newMap.put(entry.getKey(), FieldAdapterManager.getValueForStorage(entry.getValue()));
            }
            value = newMap;
        }
        return value;
    }

    public static Class<?> getComponentTypeForStorage(Class<?> componentType) {
        Class<Object> newType = componentType;
        if (componentType.equals(Date.class)) {
            newType = Calendar.class;
        }
        return newType;
    }

    public static Object getValueForDisplay(Object value) {
        if (value instanceof Calendar) {
            value = FieldAdapterManager.getCalendarAsDate((Calendar)value);
        } else if (value instanceof Object[]) {
            Object[] array = value;
            Class<?> oldType = array.getClass().getComponentType();
            Class<?> newType = FieldAdapterManager.getComponentTypeForDisplay(oldType);
            Object[] newArray = (Object[])Array.newInstance(newType, array.length);
            for (int i = 0; i < array.length; ++i) {
                newArray[i] = FieldAdapterManager.getValueForDisplay(array[i]);
            }
            value = newArray;
        } else if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, FieldAdapterManager.getValueForDisplay(list.get(i)));
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            Object[] newMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                newMap.put(entry.getKey(), FieldAdapterManager.getValueForDisplay(entry.getValue()));
            }
            value = newMap;
        }
        return value;
    }

    public static Class<?> getComponentTypeForDisplay(Class<?> componentType) {
        Class<Object> newType = componentType;
        if (componentType.equals(Calendar.class)) {
            newType = Date.class;
        }
        return newType;
    }

    private static Calendar getDateAsCalendar(Date value) {
        Calendar calValue = Calendar.getInstance();
        calValue.setTime(value);
        return calValue;
    }

    private static Date getCalendarAsDate(Calendar value) {
        return value.getTime();
    }
}

