/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.backend;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.wi.backend.AbstractCoreBackend;
import org.nuxeo.ecm.platform.wi.backend.Backend;
import org.nuxeo.ecm.platform.wi.backend.PathCache;
import org.nuxeo.runtime.api.Framework;

public class SimpleBackend
extends AbstractCoreBackend {
    private static final Log log = LogFactory.getLog(SimpleBackend.class);
    public static final String SOURCE_EDIT_KEYWORD = "source-edit";
    public static final String ALWAYS_CREATE_FILE_PROP = "nuxeo.webdav.always-create-file";
    private static final int PATH_CACHE_SIZE = 255;
    protected String backendDisplayName;
    protected String rootPath;
    protected String rootUrl;
    protected TrashService trashService;
    protected PathCache pathCache;
    protected LinkedList<String> orderedBackendNames;

    protected SimpleBackend(String backendDisplayName, String rootPath, String rootUrl, CoreSession session) {
        super(session);
        this.backendDisplayName = backendDisplayName;
        this.rootPath = rootPath;
        this.rootUrl = rootUrl;
    }

    protected SimpleBackend(String backendDisplayName, String rootPath, String rootUrl) {
        this(backendDisplayName, rootPath, rootUrl, null);
    }

    protected PathCache getPathCache() throws ClientException {
        if (this.pathCache == null) {
            this.pathCache = new PathCache(this.getSession(), 255);
        }
        return this.pathCache;
    }

    @Override
    public String getRootPath() {
        return this.rootPath;
    }

    @Override
    public String getRootUrl() {
        return this.rootUrl;
    }

    @Override
    public String getBackendDisplayName() {
        return this.backendDisplayName;
    }

    @Override
    public boolean exists(String location) {
        try {
            DocumentModel doc = this.resolveLocation(location);
            return doc != null && !this.isTrashDocument(doc);
        }
        catch (ClientException e) {
            return false;
        }
        catch (ClientRuntimeException e2) {
            return false;
        }
    }

    private boolean exists(DocumentRef ref) throws ClientException {
        if (this.getSession().exists(ref)) {
            DocumentModel model = this.getSession().getDocument(ref);
            return !this.isTrashDocument(model);
        }
        return false;
    }

    @Override
    public boolean hasPermission(DocumentRef docRef, String permission) throws ClientException {
        return this.getSession().hasPermission(docRef, permission);
    }

    @Override
    public DocumentModel updateDocument(DocumentModel doc, String name, Blob content) throws ClientException {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh != null) {
            bh.setBlob(content);
        }
        doc.putContextData(SOURCE_EDIT_KEYWORD, (Serializable)((Object)"webdav"));
        this.getSession().saveDocument(doc);
        this.saveChanges();
        return doc;
    }

    @Override
    public LinkedList<String> getVirtualFolderNames() throws ClientException {
        if (this.orderedBackendNames == null) {
            List<DocumentModel> children = this.getChildren((DocumentRef)new PathRef(this.rootPath));
            this.orderedBackendNames = new LinkedList();
            if (children != null) {
                for (DocumentModel model : children) {
                    this.orderedBackendNames.add(model.getName());
                }
            }
        }
        return this.orderedBackendNames;
    }

    @Override
    public final boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public final Backend getBackend(String path) {
        return this;
    }

    @Override
    public DocumentModel resolveLocation(String location) throws ClientException {
        Path resolvedLocation = this.parseLocation(location);
        DocumentModel doc = null;
        doc = this.getPathCache().get(resolvedLocation.toString());
        if (doc != null) {
            return doc;
        }
        PathRef docRef = new PathRef(resolvedLocation.toString());
        if (this.exists((DocumentRef)docRef)) {
            doc = this.getSession().getDocument((DocumentRef)docRef);
        } else {
            PathRef encodedPathRef;
            String encodedPath = this.urlEncode(resolvedLocation.toString());
            if (!resolvedLocation.toString().equals(encodedPath) && this.exists((DocumentRef)(encodedPathRef = new PathRef(encodedPath)))) {
                doc = this.getSession().getDocument((DocumentRef)encodedPathRef);
            }
            if (doc == null) {
                DocumentModel parentDocument;
                String folderName;
                String filename = resolvedLocation.lastSegment();
                Path parentLocation = resolvedLocation.removeLastSegments(1);
                PathRef folderRef = new PathRef(parentLocation.append(folderName = filename).toString());
                if (this.exists((DocumentRef)folderRef)) {
                    doc = this.getSession().getDocument((DocumentRef)folderRef);
                }
                if ((parentDocument = this.resolveParent(parentLocation.toString())) == null) {
                    return null;
                }
                List<DocumentModel> children = this.getChildren(parentDocument.getRef());
                for (DocumentModel child : children) {
                    Blob blob;
                    BlobHolder bh = (BlobHolder)child.getAdapter(BlobHolder.class);
                    if (bh == null || (blob = bh.getBlob()) == null) continue;
                    try {
                        String blobFilename = blob.getFilename();
                        if (filename.equals(blobFilename)) {
                            doc = child;
                            break;
                        }
                        if (this.urlEncode(filename).equals(blobFilename)) {
                            doc = child;
                            break;
                        }
                        if (URLEncoder.encode(filename, "UTF-8").equals(blobFilename)) {
                            doc = child;
                            break;
                        }
                        if (!this.encode(blobFilename.getBytes(), "ISO-8859-1").equals(filename)) continue;
                        doc = child;
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        this.getPathCache().put(resolvedLocation.toString(), doc);
        return doc;
    }

    private String urlEncode(String value) {
        try {
            return URIUtil.encodePath((String)value);
        }
        catch (URIException e) {
            log.warn((Object)("Can't encode path " + value));
            return value;
        }
    }

    protected DocumentModel resolveParent(String location) throws ClientException {
        DocumentModel doc = null;
        doc = this.getPathCache().get(location.toString());
        if (doc != null) {
            return doc;
        }
        PathRef docRef = new PathRef(location.toString());
        if (this.exists((DocumentRef)docRef)) {
            doc = this.getSession().getDocument((DocumentRef)docRef);
        } else {
            String folderName;
            Path locationPath = new Path(location);
            String filename = locationPath.lastSegment();
            Path parentLocation = locationPath.removeLastSegments(1);
            PathRef folderRef = new PathRef(parentLocation.append(folderName = filename).toString());
            if (this.exists((DocumentRef)folderRef)) {
                doc = this.getSession().getDocument((DocumentRef)folderRef);
            }
        }
        this.getPathCache().put(location.toString(), doc);
        return doc;
    }

    @Override
    public Path parseLocation(String location) {
        Path finalLocation = new Path(this.rootPath);
        Path rootUrlPath = new Path(this.rootUrl);
        Path urlLocation = new Path(location);
        Path cutLocation = urlLocation.removeFirstSegments(rootUrlPath.segmentCount());
        finalLocation = finalLocation.append(cutLocation);
        String fileName = finalLocation.lastSegment();
        String parentPath = finalLocation.removeLastSegments(1).toString();
        return new Path(parentPath).append(fileName);
    }

    @Override
    public void removeItem(String location) throws ClientException {
        DocumentModel docToRemove = null;
        try {
            docToRemove = this.resolveLocation(location);
        }
        catch (Exception e) {
            throw new ClientException("Error while resolving document path", (Throwable)e);
        }
        if (docToRemove == null) {
            throw new ClientException("Document path not found");
        }
        this.removeItem(docToRemove.getRef());
    }

    @Override
    public void removeItem(DocumentRef ref) throws ClientException {
        try {
            DocumentModel doc = this.getSession().getDocument(ref);
            if (doc != null) {
                this.getTrashService().trashDocuments(Arrays.asList(doc));
                this.getPathCache().remove(doc.getPathAsString());
            } else {
                log.warn((Object)("Can't move document " + ref.toString() + " to trash. Document did not found."));
            }
        }
        catch (ClientException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ClientException("Error while deleting doc " + ref, (Throwable)e);
        }
    }

    @Override
    public boolean isRename(String source, String destination) {
        Path sourcePath = new Path(source);
        Path destinationPath = new Path(destination);
        return sourcePath.removeLastSegments(1).toString().equals(destinationPath.removeLastSegments(1).toString());
    }

    @Override
    public void renameItem(DocumentModel source, String destinationName) throws ClientException {
        source.putContextData(SOURCE_EDIT_KEYWORD, (Serializable)((Object)"webdav"));
        if (source.isFolder()) {
            source.setPropertyValue("dc:title", (Serializable)((Object)destinationName));
            this.moveItem(source, source.getParentRef(), destinationName);
            source.putContextData("renameSource", (Serializable)((Object)"webdav"));
            this.getSession().saveDocument(source);
        } else {
            Blob blob;
            source.setPropertyValue("dc:title", (Serializable)((Object)destinationName));
            BlobHolder bh = (BlobHolder)source.getAdapter(BlobHolder.class);
            boolean blobUpdated = false;
            if (bh != null && (blob = bh.getBlob()) != null) {
                blob.setFilename(destinationName);
                blobUpdated = true;
                bh.setBlob(blob);
                this.getSession().saveDocument(source);
            }
            if (!blobUpdated) {
                source.setPropertyValue("dc:title", (Serializable)((Object)destinationName));
                this.moveItem(source, source.getParentRef(), destinationName);
                source = this.getSession().saveDocument(source);
            }
        }
    }

    @Override
    public DocumentModel moveItem(DocumentModel source, PathRef targetParentRef) throws ClientException {
        return this.moveItem(source, (DocumentRef)targetParentRef, source.getName());
    }

    @Override
    public DocumentModel moveItem(DocumentModel source, DocumentRef targetParentRef, String name) throws ClientException {
        try {
            this.cleanTrashPath(targetParentRef, name);
            DocumentModel model = this.getSession().move(source.getRef(), targetParentRef, name);
            this.getPathCache().put(this.parseLocation(targetParentRef.toString()) + "/" + name, model);
            this.getPathCache().remove(source.getPathAsString());
            return model;
        }
        catch (ClientException e) {
            this.discardChanges();
            throw new ClientException("Error while doing move", e);
        }
    }

    @Override
    public DocumentModel copyItem(DocumentModel source, PathRef targetParentRef) throws ClientException {
        try {
            DocumentModel model = this.getSession().copy(source.getRef(), (DocumentRef)targetParentRef, source.getName());
            this.getPathCache().put(this.parseLocation(targetParentRef.toString()) + "/" + source.getName(), model);
            return model;
        }
        catch (ClientException e) {
            this.discardChanges();
            throw new ClientException("Error while doing move", e);
        }
    }

    @Override
    public DocumentModel createFolder(String parentPath, String name) throws ClientException {
        DocumentModel parent = this.resolveLocation(parentPath);
        if (!parent.isFolder()) {
            throw new ClientException("Can not create a child in a non folderish node");
        }
        String targetType = "Folder";
        if ("WorkspaceRoot".equals(parent.getType())) {
            targetType = "Workspace";
        }
        try {
            this.cleanTrashPath(parent, name);
            DocumentModel folder = this.getSession().createDocumentModel(parent.getPathAsString(), name, targetType);
            folder.setPropertyValue("dc:title", (Serializable)((Object)name));
            folder = this.getSession().createDocument(folder);
            this.getPathCache().put(this.parseLocation(parentPath) + "/" + name, folder);
            return folder;
        }
        catch (Exception e) {
            this.discardChanges();
            throw new ClientException("Error child creating new folder", (Throwable)e);
        }
    }

    @Override
    public DocumentModel createFile(String parentPath, String name, Blob content) throws ClientException {
        DocumentModel parent = this.resolveLocation(parentPath);
        if (!parent.isFolder()) {
            throw new ClientException("Can not create a child in a non folderish node");
        }
        try {
            DocumentModel file;
            this.cleanTrashPath(parent, name);
            if (Boolean.parseBoolean(Framework.getProperty((String)ALWAYS_CREATE_FILE_PROP, (String)"false"))) {
                BlobHolder bh;
                file = this.getSession().createDocumentModel(parent.getPathAsString(), name, "File");
                file.setPropertyValue("dc:title", (Serializable)((Object)name));
                if (content != null && (bh = (BlobHolder)file.getAdapter(BlobHolder.class)) != null) {
                    bh.setBlob(content);
                }
                file = this.getSession().createDocument(file);
            } else {
                FileManager fileManager = (FileManager)Framework.getLocalService(FileManager.class);
                file = fileManager.createDocumentFromBlob(this.getSession(), content, parent.getPathAsString(), false, name);
            }
            this.getPathCache().put(this.parseLocation(parentPath) + "/" + name, file);
            return file;
        }
        catch (Exception e) {
            this.discardChanges();
            throw new ClientException("Error child creating new folder", (Throwable)e);
        }
    }

    @Override
    public DocumentModel createFile(String parentPath, String name) throws ClientException {
        ByteArrayBlob blob = new ByteArrayBlob(new byte[0], "application/octet-stream");
        return this.createFile(parentPath, name, (Blob)blob);
    }

    @Override
    public String getDisplayName(DocumentModel doc) {
        if (doc.isFolder()) {
            return doc.getName();
        }
        String fileName = this.getFileName(doc);
        if (fileName == null) {
            fileName = doc.getName();
        }
        return fileName;
    }

    @Override
    public List<DocumentModel> getChildren(DocumentRef ref) throws ClientException {
        ArrayList<DocumentModel> result = new ArrayList<DocumentModel>();
        DocumentModelList children = this.getSession(true).getChildren(ref);
        for (DocumentModel child : children) {
            if (child.hasFacet("HiddenInNavigation") || "deleted".equals(child.getCurrentLifeCycleState()) || !child.hasSchema("dublincore") || !child.hasFacet("Folderish") && child.getAdapter(BlobHolder.class) == null) continue;
            result.add(child);
        }
        return result;
    }

    @Override
    public boolean isLocked(DocumentRef ref) throws ClientException {
        Lock lock = this.getSession().getLockInfo(ref);
        return lock != null;
    }

    @Override
    public boolean canUnlock(DocumentRef ref) throws ClientException {
        Principal principal = this.getSession().getPrincipal();
        if (principal == null || StringUtils.isEmpty((String)principal.getName())) {
            log.error((Object)"Empty session principal. Error while canUnlock check.");
            return false;
        }
        String checkoutUser = this.getCheckoutUser(ref);
        return principal.getName().equals(checkoutUser);
    }

    @Override
    public String lock(DocumentRef ref) throws ClientException {
        if (this.getSession().hasPermission(ref, "WriteProperties")) {
            Lock lock = this.getSession().setLock(ref);
            return lock.getOwner();
        }
        return "readonly";
    }

    @Override
    public boolean unlock(DocumentRef ref) throws ClientException {
        if (!this.canUnlock(ref)) {
            return false;
        }
        this.getSession().removeLock(ref);
        return true;
    }

    @Override
    public String getCheckoutUser(DocumentRef ref) throws ClientException {
        Lock lock = this.getSession().getLockInfo(ref);
        if (lock != null) {
            return lock.getOwner();
        }
        return null;
    }

    @Override
    public String getVirtualPath(String path) {
        if (path.startsWith(this.rootPath)) {
            return this.rootUrl + path.substring(this.rootPath.length());
        }
        return null;
    }

    @Override
    public DocumentModel getDocument(String location) throws ClientException {
        return this.resolveLocation(location);
    }

    protected String getFileName(DocumentModel doc) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh != null) {
            try {
                Blob blob = bh.getBlob();
                if (blob != null) {
                    return blob.getFilename();
                }
            }
            catch (ClientException e) {
                log.error((Object)"Unable to get filename", (Throwable)e);
            }
        }
        return null;
    }

    protected boolean isTrashDocument(DocumentModel model) throws ClientException {
        if (model == null) {
            return true;
        }
        return "deleted".equals(model.getCurrentLifeCycleState());
    }

    protected TrashService getTrashService() throws Exception {
        if (this.trashService == null) {
            this.trashService = (TrashService)Framework.getService(TrashService.class);
        }
        return this.trashService;
    }

    protected boolean cleanTrashPath(DocumentModel parent, String name) throws ClientException {
        DocumentModel model;
        Path checkedPath = new Path(parent.getPathAsString()).append(name);
        if (this.getSession().exists((DocumentRef)new PathRef(checkedPath.toString())) && (model = this.getSession().getDocument((DocumentRef)new PathRef(checkedPath.toString()))) != null && "deleted".equals(model.getCurrentLifeCycleState())) {
            name = name + "." + System.currentTimeMillis();
            this.getSession().move(model.getRef(), parent.getRef(), name);
            return true;
        }
        return false;
    }

    protected boolean cleanTrashPath(DocumentRef parentRef, String name) throws ClientException {
        DocumentModel parent = this.getSession().getDocument(parentRef);
        return this.cleanTrashPath(parent, name);
    }

    protected String encode(byte[] bytes, String encoding) throws ClientException {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Unsupported encoding " + encoding);
        }
    }
}

