/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.ConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.repository.RepositoryDescriptor;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepository;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionFactoryImpl;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;
import org.nuxeo.runtime.jtajca.NuxeoContainer;

public class PoolingRepositoryFactory
implements RepositoryFactory {
    private static final Log log = LogFactory.getLog(PoolingRepositoryFactory.class);
    private static final String[] CM_NAMES_PREFIXES = new String[]{"java:comp/NuxeoConnectionManager/", "java:comp/env/NuxeoConnectionManager/", "java:NuxeoConnectionManager/"};

    public Repository createRepository(RepositoryDescriptor descriptor) throws Exception {
        String repositoryName = descriptor.getName();
        log.info((Object)("Creating pooling repository: " + repositoryName));
        ManagedConnectionFactoryImpl managedConnectionFactory = new ManagedConnectionFactoryImpl(SQLRepository.getDescriptor((RepositoryDescriptor)descriptor));
        ConnectionManager connectionManager = PoolingRepositoryFactory.lookupConnectionManager(descriptor);
        return (Repository)managedConnectionFactory.createConnectionFactory(connectionManager);
    }

    protected static ConnectionManager lookupConnectionManager(RepositoryDescriptor descriptor) throws NamingException {
        String repositoryName = descriptor.getName();
        ConnectionManager cm = NuxeoContainer.getConnectionManager((String)repositoryName);
        if (cm != null) {
            return cm;
        }
        InitialContext context = new InitialContext();
        for (String name : CM_NAMES_PREFIXES) {
            try {
                cm = (ConnectionManager)context.lookup(name + repositoryName);
                if (cm == null) continue;
                return cm;
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        cm = NuxeoContainer.installConnectionManager((String)repositoryName, (NuxeoConnectionManagerConfiguration)descriptor.getPool());
        if (cm != null) {
            return cm;
        }
        throw new NamingException("NuxeoConnectionManager not found in JNDI");
    }
}

