/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.elements;

import java.io.StringWriter;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.engines.EngineType;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatFilter;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.models.InfoPool;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.theme.nodes.Node;
import org.nuxeo.theme.rendering.Filter;
import org.nuxeo.theme.rendering.FilterType;
import org.nuxeo.theme.rendering.FilterTypeFamily;
import org.nuxeo.theme.rendering.RendererType;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;

public final class ElementRenderer {
    private static final Log log = LogFactory.getLog(ElementRenderer.class);

    private ElementRenderer() {
    }

    public static RenderingInfo render(RenderingInfo info) {
        return ElementRenderer.render(info, true);
    }

    public static RenderingInfo render(RenderingInfo info, boolean cache) {
        InfoPool.register(info);
        StringWriter rendered = new StringWriter();
        URL themeUrl = info.getThemeUrl();
        if (themeUrl == null) {
            log.warn((Object)("Theme URL not set for the element: " + info.getElement()));
        }
        EngineType engine = info.getEngine();
        Element element = info.getElement();
        String markup = "";
        if (element.isLeaf()) {
            Fragment fragment;
            block17: {
                if (!(element instanceof Fragment)) {
                    log.error((Object)String.format("Leaf nodes must be fragments, ignoring element: %s", element.getElementType().getTypeName()));
                    return info;
                }
                fragment = (Fragment)element;
                try {
                    info.setModel(fragment.getModel());
                }
                catch (ModelException e) {
                    if (!info.isDirty()) break block17;
                    String fragmentName = fragment.getFragmentType().getTypeName();
                    log.error((Object)("Rendering of fragment '" + fragmentName + "' failed."), (Throwable)e);
                    return info;
                }
            }
            if (fragment.isDynamic()) {
                info.setDirty(true);
            }
        } else {
            for (Node child : element.getChildrenInContext(themeUrl)) {
                RenderingInfo childInfo = new RenderingInfo((Element)child, themeUrl);
                RenderingInfo renderedChild = ElementRenderer.render(childInfo);
                if (renderedChild == null) continue;
                rendered.append(renderedChild.getMarkup());
            }
            markup = rendered.toString();
        }
        info.setMarkup(markup);
        RendererType renderer = engine.getRenderers().get(element.getElementType().getTypeName());
        if (renderer == null) {
            return info;
        }
        String templateEngineName = info.getTemplateEngine().getName();
        String engineName = info.getEngine().getName();
        String viewMode = info.getViewMode();
        for (String filterName : renderer.getFilters()) {
            FilterType filterType = ElementRenderer.getFilterFor(engineName, filterName, templateEngineName, viewMode);
            if (filterType == null) {
                filterType = ElementRenderer.getFilterFor("*", filterName, templateEngineName, viewMode);
            }
            if (filterType == null) {
                log.warn((Object)("Filter type '" + filterName + "' not found."));
                continue;
            }
            Filter filter = filterType.getFilter();
            if (filter == null) {
                log.warn((Object)("Filter instantiation failed: " + filterName));
                continue;
            }
            FilterTypeFamily filterTypeFamily = filterType.getFilterTypeFamily();
            if (filterTypeFamily == FilterTypeFamily.FORMAT) {
                FormatType formatType = ((FormatFilter)filter).getFormatType();
                Format format = ElementFormatter.getFormatByType(element, formatType);
                if (format == null) {
                    log.debug((Object)("Could not find '" + formatType.getTypeName() + "' format for: " + element.getElementType().getTypeName()));
                    continue;
                }
                info.setFormat(format);
            } else if (filterTypeFamily != FilterTypeFamily.STANDALONE) {
                log.warn((Object)("Unsupported filter type: " + filterName));
            }
            if ((info = filter.process(info, cache)) != null) continue;
            break;
        }
        return info;
    }

    private static FilterType getFilterFor(String engineName, String filterName, String templateEngineName, String viewMode) {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        FilterType filterType = (FilterType)typeRegistry.lookup(TypeFamily.FILTER, String.format("%s/%s/%s/%s", engineName, templateEngineName, viewMode, filterName));
        if (filterType == null) {
            filterType = (FilterType)typeRegistry.lookup(TypeFamily.FILTER, String.format("%s/%s/*/%s", engineName, templateEngineName, filterName));
        }
        if (filterType == null) {
            filterType = (FilterType)typeRegistry.lookup(TypeFamily.FILTER, String.format("%s/*/*/%s", engineName, filterName));
        }
        return filterType;
    }
}

