/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.negotiation;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.negotiation.NegotiationException;
import org.nuxeo.theme.negotiation.NegotiationType;
import org.nuxeo.theme.negotiation.Negotiator;
import org.nuxeo.theme.negotiation.Scheme;
import org.nuxeo.theme.types.TypeFamily;

public abstract class AbstractNegotiator
implements Negotiator {
    private static final String SPEC_PREFIX = "nxtheme://theme";
    private static final String DEFAULT_NEGOTIATION_STRATEGY = "default";
    protected final String strategy;
    protected final Object context;
    protected final HttpServletRequest request;

    public abstract String getTemplateEngineName();

    protected AbstractNegotiator(String strategy, Object context, HttpServletRequest request) {
        this.strategy = strategy;
        this.context = context;
        this.request = request;
    }

    @Override
    public final String getSpec() throws NegotiationException {
        return String.format("%s/%s/%s/%s/%s/%s/%s", SPEC_PREFIX, this.negotiate("engine"), this.negotiate("mode"), this.getTemplateEngineName(), this.negotiate("theme"), this.negotiate("perspective"), this.negotiate("collection"));
    }

    @Override
    public final synchronized String negotiate(String object) throws NegotiationException {
        if (this.strategy == null) {
            throw new NegotiationException("No negotiation strategy is set.");
        }
        NegotiationType negotiation = (NegotiationType)Manager.getTypeRegistry().lookup(TypeFamily.NEGOTIATION, String.format("%s/%s", this.strategy, object));
        if (negotiation == null) {
            negotiation = (NegotiationType)Manager.getTypeRegistry().lookup(TypeFamily.NEGOTIATION, String.format("%s/%s", DEFAULT_NEGOTIATION_STRATEGY, object));
        }
        if (negotiation == null) {
            throw new NegotiationException("Could not obtain negotiation for: " + this.strategy + " (strategy) " + object + " (object)");
        }
        List<Scheme> schemes = negotiation.getSchemes();
        String outcome = null;
        if (schemes != null) {
            Scheme scheme;
            Iterator<Scheme> i$ = negotiation.getSchemes().iterator();
            while (i$.hasNext() && (outcome = (scheme = i$.next()).getOutcome(this.context)) == null) {
            }
        }
        if (outcome == null) {
            throw new NegotiationException("No negotiation outcome found for:  " + this.strategy + " (strategy) " + object + " (object)");
        }
        this.request.setAttribute("org.nuxeo.theme.negotiation.result." + object, outcome);
        return outcome;
    }
}

