/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.themes;

import java.io.BufferedWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.nodes.Node;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.presets.PresetManager;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.properties.FieldIO;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeIOException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.uids.Identifiable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ThemeSerializer {
    private static final Log log = LogFactory.getLog(ThemeSerializer.class);
    private static final String DOCROOT_NAME = "theme";
    private Document doc;
    private List<org.nuxeo.theme.elements.Element> elements;

    public Document serialize(String src) throws Exception {
        String resourceBankName;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.debug((Object)"Could not set DTD non-validation feature");
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.newDocument();
        this.elements = new ArrayList<org.nuxeo.theme.elements.Element>();
        Element root = this.doc.createElement(DOCROOT_NAME);
        ThemeManager themeManager = Manager.getThemeManager();
        ThemeElement theme = themeManager.getThemeBySrc(src);
        String description = theme.getDescription();
        if (description != null) {
            root.setAttribute("description", description);
        }
        String themeName = theme.getName();
        root.setAttribute("name", themeName);
        ThemeDescriptor themeDef = ThemeManager.getThemeDescriptor(src);
        List<String> templateEngines = themeDef.getTemplateEngines();
        if (templateEngines != null && templateEngines.size() > 0) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = templateEngines.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            root.setAttribute("template-engines", sb.toString());
        }
        if ((resourceBankName = themeDef.getResourceBankName()) != null) {
            root.setAttribute("resource-bank", resourceBankName);
        }
        this.doc.appendChild(root);
        Element layoutNode = this.doc.createElement("layout");
        root.appendChild(layoutNode);
        for (Node page : theme.getChildren()) {
            this.serializeLayout((org.nuxeo.theme.elements.Element)page, layoutNode);
        }
        for (org.nuxeo.theme.elements.Element element : this.elements) {
            this.serializeProperties(element, root);
        }
        List<PresetType> customPresets = PresetManager.getCustomPresets(themeName);
        if (!customPresets.isEmpty()) {
            Element presetsNode = this.doc.createElement("presets");
            root.appendChild(presetsNode);
            for (PresetType preset : customPresets) {
                Element presetNode = this.doc.createElement("preset");
                presetNode.setAttribute("name", preset.getName());
                presetNode.setAttribute("category", preset.getCategory());
                presetNode.setAttribute("label", preset.getLabel());
                presetNode.setAttribute("description", preset.getDescription());
                presetNode.appendChild(this.doc.createTextNode(preset.getValue()));
                presetsNode.appendChild(presetNode);
            }
        }
        Element formatNode = this.doc.createElement("formats");
        root.appendChild(formatNode);
        for (String formatTypeName : themeManager.getFormatTypeNames()) {
            for (Identifiable object : themeManager.getNamedObjects(themeName, formatTypeName)) {
                Format format = (Format)object;
                if (!format.isCustomized() && ThemeManager.listFormatsDirectlyInheritingFrom(format).isEmpty()) continue;
                this.serializeFormat(format, formatNode);
            }
            for (Format format : themeManager.getFormatsByTypeName(formatTypeName)) {
                if (format.isNamed()) continue;
                boolean isUsedByThisTheme = false;
                for (org.nuxeo.theme.elements.Element element : ElementFormatter.getElementsFor(format)) {
                    if (!element.isChildOf(theme) && element != theme) continue;
                    isUsedByThisTheme = true;
                    break;
                }
                if (!isUsedByThisTheme) continue;
                this.serializeFormat(format, formatNode);
            }
        }
        return this.doc;
    }

    private void serializeProperties(org.nuxeo.theme.elements.Element parent, Element domParent) throws Exception {
        Element domProperties = this.doc.createElement("properties");
        domProperties.setAttribute("element", parent.computeXPath());
        for (Map.Entry<Object, Object> entry : FieldIO.dumpFieldsToProperties(parent).entrySet()) {
            Element domProperty = this.doc.createElement((String)entry.getKey());
            String value = (String)entry.getValue();
            domProperty.appendChild(this.doc.createTextNode(Utils.cleanUp(value)));
            domProperties.appendChild(domProperty);
        }
        if (domProperties.hasChildNodes()) {
            domParent.appendChild(domProperties);
        }
    }

    private void serializeLayout(org.nuxeo.theme.elements.Element parent, Element domParent) {
        String description;
        String elementClassName;
        String typeName = parent.getElementType().getTypeName();
        Element domElement = this.doc.createElement(typeName);
        this.elements.add(parent);
        String elementName = parent.getName();
        if (elementName != null) {
            domElement.setAttribute("name", elementName);
        }
        if ((elementClassName = parent.getCssClassName()) != null) {
            domElement.setAttribute("class", elementClassName);
        }
        if (parent instanceof Fragment) {
            domElement.setAttribute("type", ((Fragment)parent).getFragmentType().getTypeName());
            StringBuilder s = new StringBuilder();
            Iterator<PerspectiveType> it = ((Fragment)parent).getVisibilityPerspectives().iterator();
            while (it.hasNext()) {
                PerspectiveType perspective = it.next();
                s.append(perspective.getTypeName());
                if (!it.hasNext()) continue;
                s.append(",");
            }
            if (s.length() > 0) {
                domElement.setAttribute("perspectives", s.toString());
            }
        }
        if ((description = parent.getDescription()) != null) {
            domParent.appendChild(this.doc.createComment(String.format(" %s ", description)));
        }
        domParent.appendChild(domElement);
        for (Node child : parent.getChildren()) {
            this.serializeLayout((org.nuxeo.theme.elements.Element)child, domElement);
        }
    }

    private void serializeFormat(Format format, Element domParent) {
        String typeName = format.getFormatType().getTypeName();
        Element domElement = this.doc.createElement(typeName);
        String description = format.getDescription();
        if (description != null) {
            domParent.appendChild(this.doc.createComment(String.format(" %s ", description)));
        }
        StringBuilder s = new StringBuilder();
        Iterator<org.nuxeo.theme.elements.Element> iter = ElementFormatter.getElementsFor(format).iterator();
        boolean hasElement = iter.hasNext();
        while (iter.hasNext()) {
            org.nuxeo.theme.elements.Element element = iter.next();
            s.append(element.computeXPath());
            if (!iter.hasNext()) continue;
            s.append("|");
        }
        if (hasElement) {
            domElement.setAttribute("element", s.toString());
        }
        if ("widget".equals(typeName)) {
            String viewName = format.getName();
            Element domView = this.doc.createElement("view");
            domView.appendChild(this.doc.createTextNode(viewName));
            domElement.appendChild(domView);
            Properties properties = format.getProperties();
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if ("view".equals(name)) continue;
                String value = properties.getProperty(name);
                Element domAttr = this.doc.createElement(name);
                domAttr.appendChild(this.doc.createTextNode(Utils.cleanUp(value)));
                domElement.appendChild(domAttr);
            }
        } else if ("layout".equals(typeName)) {
            Properties properties = format.getProperties();
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = properties.getProperty(name);
                Element domView = this.doc.createElement(name);
                domView.appendChild(this.doc.createTextNode(Utils.cleanUp(value)));
                domElement.appendChild(domView);
            }
        } else if ("style".equals(typeName)) {
            Style style = (Style)format;
            if (style.isExternal()) {
                return;
            }
            String styleName = style.getName();
            Style ancestor = (Style)ThemeManager.getAncestorFormatOf(style);
            if (styleName != null) {
                domElement.setAttribute("name", styleName);
            }
            if (ancestor != null) {
                domElement.setAttribute("inherit", ancestor.getName());
            }
            if (style.isRemote()) {
                domElement.setAttribute("remote", "true");
            }
            if (!style.isRemote() || style.isCustomized()) {
                for (String viewName : style.getSelectorViewNames()) {
                    for (String path : style.getPathsForView(viewName)) {
                        Properties styleProperties = style.getPropertiesFor(viewName, path);
                        if (styleProperties.isEmpty()) continue;
                        Element domSelector = this.doc.createElement("selector");
                        path = Utils.cleanUp(path);
                        domSelector.setAttribute("path", path);
                        if (!"*".equals(viewName)) {
                            domSelector.setAttribute("view", viewName);
                        }
                        for (Map.Entry<Object, Object> entry : styleProperties.entrySet()) {
                            Element domProperty = this.doc.createElement((String)entry.getKey());
                            String value = (String)entry.getValue();
                            String presetName = PresetManager.extractPresetName(null, value);
                            if (presetName != null) {
                                domProperty.setAttribute("preset", presetName);
                            } else {
                                domProperty.appendChild(this.doc.createTextNode(Utils.cleanUp(value)));
                            }
                            domSelector.appendChild(domProperty);
                        }
                        String selectorDescription = style.getSelectorDescription(path, viewName);
                        if (selectorDescription != null) {
                            domElement.appendChild(this.doc.createComment(String.format(" %s ", selectorDescription)));
                        }
                        domElement.appendChild(domSelector);
                    }
                }
            }
        }
        domParent.appendChild(domElement);
    }

    public String serializeToXml(String src) throws ThemeIOException {
        return this.serializeToXml(src, 0);
    }

    public String serializeToXml(String src, int indent) throws ThemeIOException {
        try {
            this.serialize(src);
            StringWriter sw = new StringWriter();
            OutputFormat format = new OutputFormat(this.doc);
            format.setIndenting(true);
            format.setIndent(indent);
            BufferedWriter output = new BufferedWriter(sw);
            XMLSerializer serializer = new XMLSerializer((Writer)output, format);
            serializer.serialize(this.doc);
            return sw.toString();
        }
        catch (Exception e) {
            throw new ThemeIOException(e);
        }
    }
}

