/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scheduler;

import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.scheduler.SchedulerService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.LoginAs;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EventJob
implements Job {
    private static final Log log = LogFactory.getLog(EventJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        ClassLoader nuxeoCL = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(nuxeoCL);
        try {
            this.execute(dataMap);
        }
        catch (Exception e) {
            String eventId = dataMap.getString("eventId");
            log.error((Object)("Error while processing scheduled event id: " + eventId), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(JobDataMap dataMap) throws Exception {
        String eventId = dataMap.getString("eventId");
        String eventCategory = dataMap.getString("eventCategory");
        String username = dataMap.getString("username");
        SchedulerService scheduler = (SchedulerService)Framework.getLocalService(SchedulerService.class);
        if (scheduler == null || !scheduler.hasApplicationStarted()) {
            return;
        }
        EventService eventService = (EventService)Framework.getService(EventService.class);
        if (eventService == null) {
            log.error((Object)"Cannot find EventService");
            return;
        }
        LoginContext loginContext = null;
        try {
            if (username == null) {
                loginContext = Framework.login();
            } else if (Framework.getLocalService(LoginAs.class) != null) {
                loginContext = Framework.loginAsUser((String)username);
            } else if (!Framework.isTestModeSet()) {
                log.error((Object)"LoginAs service not available");
            }
            UserPrincipal principal = new UserPrincipal(username, null, false, false);
            EventContextImpl eventContext = new EventContextImpl(null, (Principal)principal);
            eventContext.setProperty("category", (Serializable)((Object)eventCategory));
            eventContext.setProperties((Map<String, Serializable>)dataMap);
            EventImpl event = new EventImpl(eventId, eventContext);
            boolean tx = TransactionHelper.startTransaction();
            log.debug((Object)("Sending scheduled event id=" + eventId + ", category=" + eventCategory + ", username=" + username));
            boolean ok = false;
            try {
                eventService.fireEvent(event);
                ok = true;
            }
            finally {
                if (tx) {
                    if (!ok) {
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        }
        finally {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
    }
}

