/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.localconfiguration.simple.operations;

import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.platform.localconfiguration.simple.SimpleConfiguration;

@Operation(id="LocalConfiguration.PutSimpleConfigurationParameters", category="Local Configuration", label="Put Simple Configuration parameters", description="Put Simple Configuration parameters on the input document. Add the 'SimpleConfiguration' facet on the input document if needed. The parameters are specified as <i>key=value</i> pairs separated by a new line. The user adding parameters must have WRITE access on the input document.")
public class PutSimpleConfigurationParameters {
    public static final String ID = "LocalConfiguration.PutSimpleConfigurationParameters";
    @Context
    protected CoreSession session;
    @Context
    protected LocalConfigurationService localConfigurationService;
    @Param(name="parameters")
    protected Properties parameters;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (!doc.hasFacet("SimpleConfiguration")) {
            doc.addFacet("SimpleConfiguration");
            doc = this.session.saveDocument(doc);
        }
        SimpleConfiguration simpleConfiguration = (SimpleConfiguration)this.localConfigurationService.getConfiguration(SimpleConfiguration.class, "SimpleConfiguration", doc);
        simpleConfiguration.putAll((Map<String, String>)this.parameters);
        simpleConfiguration.save(this.session);
        if (this.save) {
            doc = this.session.saveDocument(doc);
        }
        return doc;
    }
}

