/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.operation;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.operation.Modification;

public class ModificationSet
implements Serializable,
Iterable<Modification> {
    private static final long serialVersionUID = 6074152814184873084L;
    private static final int SIZE = 4;
    private Modification[] ar = new Modification[4];
    private int length = 0;

    public int size() {
        return this.length;
    }

    public boolean add(DocumentRef ref, int modifType) {
        if (this.length == this.ar.length) {
            Modification[] tmp = new Modification[this.ar.length + 4];
            System.arraycopy(this.ar, 0, tmp, 0, this.ar.length);
            this.ar = tmp;
        }
        this.ar[this.length++] = new Modification(ref, modifType);
        return false;
    }

    public boolean add(Modification modif) {
        return this.add(modif.ref, modif.type);
    }

    public boolean contains(DocumentRef ref) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.ar[i].ref.equals(ref)) continue;
            return true;
        }
        return false;
    }

    public final Modification get(int index) {
        return this.ar[index];
    }

    public int indexOf(DocumentRef ref) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.ar[i].ref.equals(ref)) continue;
            return i;
        }
        return -1;
    }

    public Modification remove(int index) {
        if (index >= this.length || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Modification mod = this.ar[index];
        if (index == this.length - 1) {
            this.ar[--this.length] = null;
        } else {
            System.arraycopy(this.ar, index + 1, this.ar, index, this.ar.length - index - 1);
            --this.length;
        }
        return mod;
    }

    public Modification[] toArray() {
        Modification[] tmp = new Modification[this.length];
        System.arraycopy(this.ar, 0, tmp, 0, this.ar.length);
        return tmp;
    }

    @Override
    public Iterator<Modification> iterator() {
        return new ModifIterator();
    }

    class ModifIterator
    implements Iterator<Modification> {
        int index = 0;

        ModifIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ModificationSet.this.length;
        }

        @Override
        public Modification next() {
            try {
                return ModificationSet.this.ar[this.index++];
            }
            catch (Throwable t) {
                throw new NoSuchElementException("Iterator has no more elements");
            }
        }

        @Override
        public void remove() {
            ModificationSet.this.remove(this.index);
        }
    }
}

