/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.localconfiguration.content.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.model.SelectItem;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.directory.SelectItemComparator;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="contentViewConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class ContentViewConfigurationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient SchemaManager schemaManager;
    @In(create=true)
    protected transient TypeManager typeManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected ContentViewService contentViewService;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;

    protected SchemaManager getSchemaManager() throws ClientException {
        if (this.schemaManager == null) {
            try {
                this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            }
            catch (Exception e) {
                throw new ClientException("can NOT obtain schema manager", (Throwable)e);
            }
        }
        return this.schemaManager;
    }

    public List<SelectItem> getAvailableDocTypes() throws ClientException {
        Type currentDocType;
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        Set folderishDocTypeNames = this.getSchemaManager().getDocumentTypeNamesForFacet("Folderish");
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String currentDocTypeName = currentDocument.getType();
        Collection allowedSubTypes = this.typeManager.findAllAllowedSubTypesFrom(currentDocTypeName);
        if (!allowedSubTypes.contains(currentDocType = this.typeManager.getType(currentDocTypeName))) {
            allowedSubTypes.add(currentDocType);
        }
        for (Type type : allowedSubTypes) {
            String typeName = type.getId();
            if (!folderishDocTypeNames.contains(typeName)) continue;
            Map messages = this.resourcesAccessor.getMessages();
            SelectItem item = messages.containsKey(typeName) ? new SelectItem((Object)typeName, (String)messages.get(typeName)) : new SelectItem((Object)typeName);
            items.add(item);
        }
        Collections.sort(items, new SelectItemComparator("label", true));
        return items;
    }

    public List<SelectItem> getAvailableContentViews() throws ClientException {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (String cvName : this.contentViewService.getContentViewNames()) {
            SelectItem item;
            ContentViewHeader contentViewHeader = this.contentViewService.getContentViewHeader(cvName);
            String title = contentViewHeader.getTitle();
            if (title == null) {
                item = new SelectItem((Object)cvName);
            } else {
                if (contentViewHeader.isTranslateTitle()) {
                    title = (String)this.resourcesAccessor.getMessages().get(title);
                }
                item = new SelectItem((Object)cvName, title);
            }
            items.add(item);
        }
        Collections.sort(items, new SelectItemComparator("label", true));
        return items;
    }
}

