/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class MSOffice2TextConverter
implements Converter {
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        File f = null;
        OutputStream fas = null;
        try {
            POITextExtractor extractor = ExtractorFactory.createExtractor((InputStream)blobHolder.getBlob().getStream());
            String extractedText = extractor.getText().replace("\r\n", "\n");
            byte[] bytes = extractedText.getBytes("UTF-8");
            f = File.createTempFile("po-msoffice2text", ".txt");
            fas = new FileOutputStream(f);
            fas.write(bytes);
            FileBlob blob = new FileBlob((InputStream)new FileInputStream(f), "text/plain", "UTF-8");
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)blob);
            return simpleCachableBlobHolder;
        }
        catch (Exception e) {
            throw new ConversionException("Error during MSOffice2Text conversion", e);
        }
        finally {
            if (fas != null) {
                try {
                    fas.close();
                }
                catch (IOException e) {}
            }
            if (f != null) {
                f.delete();
            }
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

