/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellType;

public final class XSSFCell
implements Cell {
    private static POILogger logger = POILogFactory.getLogger(XSSFCell.class);
    private static final String FALSE_AS_STRING = "0";
    private static final String TRUE_AS_STRING = "1";
    private final CTCell cell;
    private final XSSFRow row;
    private int cellNum;
    private SharedStringsTable sharedStringSource;
    private StylesTable stylesSource;

    protected XSSFCell(XSSFRow row, CTCell cell) {
        this.cell = cell;
        this.row = row;
        if (cell.getR() != null) {
            this.cellNum = XSSFCell.parseCellNum(cell.getR());
        }
        this.sharedStringSource = row.getSheet().getWorkbook().getSharedStringSource();
        this.stylesSource = row.getSheet().getWorkbook().getStylesSource();
    }

    protected SharedStringsTable getSharedStringSource() {
        return this.sharedStringSource;
    }

    protected StylesTable getStylesSource() {
        return this.stylesSource;
    }

    public XSSFSheet getSheet() {
        return this.getRow().getSheet();
    }

    public XSSFRow getRow() {
        return this.row;
    }

    public boolean getBooleanCellValue() {
        int cellType = this.getCellType();
        switch (cellType) {
            case 3: {
                return false;
            }
            case 4: {
                return this.cell.isSetV() && TRUE_AS_STRING.equals(this.cell.getV());
            }
            case 2: {
                return this.cell.isSetV() && TRUE_AS_STRING.equals(this.cell.getV());
            }
        }
        throw XSSFCell.typeMismatch(4, cellType, false);
    }

    public void setCellValue(boolean value) {
        this.cell.setT(STCellType.B);
        this.cell.setV(value ? TRUE_AS_STRING : FALSE_AS_STRING);
    }

    public double getNumericCellValue() {
        int cellType = this.getCellType();
        switch (cellType) {
            case 3: {
                return 0.0;
            }
            case 0: 
            case 2: {
                return this.cell.isSetV() ? Double.parseDouble(this.cell.getV()) : 0.0;
            }
        }
        throw XSSFCell.typeMismatch(0, cellType, false);
    }

    public void setCellValue(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            this.cell.setT(STCellType.E);
            this.cell.setV(FormulaError.NUM.getString());
        } else {
            this.cell.setT(STCellType.N);
            this.cell.setV(String.valueOf(value));
        }
    }

    public String getStringCellValue() {
        XSSFRichTextString str = this.getRichStringCellValue();
        return str == null ? null : str.getString();
    }

    public XSSFRichTextString getRichStringCellValue() {
        XSSFRichTextString rt;
        int cellType = this.getCellType();
        switch (cellType) {
            case 3: {
                rt = new XSSFRichTextString("");
                break;
            }
            case 1: {
                if (this.cell.getT() == STCellType.INLINE_STR) {
                    if (this.cell.isSetIs()) {
                        rt = new XSSFRichTextString(this.cell.getIs());
                        break;
                    }
                    if (this.cell.isSetV()) {
                        rt = new XSSFRichTextString(this.cell.getV());
                        break;
                    }
                    rt = new XSSFRichTextString("");
                    break;
                }
                if (this.cell.isSetV()) {
                    int idx = Integer.parseInt(this.cell.getV());
                    rt = new XSSFRichTextString(this.sharedStringSource.getEntryAt(idx));
                    break;
                }
                rt = new XSSFRichTextString("");
                break;
            }
            case 2: {
                rt = new XSSFRichTextString(this.cell.isSetV() ? this.cell.getV() : "");
                break;
            }
            default: {
                throw XSSFCell.typeMismatch(1, cellType, false);
            }
        }
        rt.setStylesTableReference(this.stylesSource);
        return rt;
    }

    public void setCellValue(String str) {
        this.setCellValue(str == null ? null : new XSSFRichTextString(str));
    }

    public void setCellValue(RichTextString str) {
        if (str == null || str.getString() == null) {
            this.setBlank();
            return;
        }
        int cellType = this.getCellType();
        switch (cellType) {
            case 2: {
                this.cell.setV(str.getString());
                this.cell.setT(STCellType.STR);
                break;
            }
            default: {
                if (this.cell.getT() == STCellType.INLINE_STR) {
                    this.cell.setV(str.getString());
                    break;
                }
                this.cell.setT(STCellType.S);
                XSSFRichTextString rt = (XSSFRichTextString)str;
                rt.setStylesTableReference(this.stylesSource);
                int sRef = this.sharedStringSource.addEntry(rt.getCTRst());
                this.cell.setV(Integer.toString(sRef));
            }
        }
    }

    public String getCellFormula() {
        int cellType = this.getCellType();
        if (cellType != 2) {
            throw XSSFCell.typeMismatch(2, cellType, false);
        }
        CTCellFormula f = this.cell.getF();
        if (f.getT() == STCellFormulaType.SHARED) {
            return this.convertSharedFormula((int)f.getSi());
        }
        return f.getStringValue();
    }

    private String convertSharedFormula(int idx) {
        XSSFSheet sheet = this.getSheet();
        XSSFCell sfCell = sheet.getSharedFormulaCell(idx);
        if (sfCell == null) {
            throw new IllegalStateException("Shared Formula not found for group index " + idx);
        }
        String sharedFormula = sfCell.getCTCell().getF().getStringValue();
        int sheetIndex = sheet.getWorkbook().getSheetIndex(sheet);
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(sheet.getWorkbook());
        Ptg[] ptgs = FormulaParser.parse((String)sharedFormula, (FormulaParsingWorkbook)fpb, (int)0, (int)sheetIndex);
        Ptg[] fmla = SharedFormulaRecord.convertSharedFormulas((Ptg[])ptgs, (int)(this.getRowIndex() - sfCell.getRowIndex()), (int)(this.getColumnIndex() - sfCell.getColumnIndex()));
        return FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])fmla);
    }

    public void setCellFormula(String formula) {
        XSSFWorkbook wb = this.row.getSheet().getWorkbook();
        if (formula == null) {
            wb.onDeleteFormula(this);
            if (this.cell.isSetF()) {
                this.cell.unsetF();
            }
            return;
        }
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        FormulaParser.parse((String)formula, (FormulaParsingWorkbook)fpb, (int)0, (int)wb.getSheetIndex(this.getSheet()));
        CTCellFormula f = CTCellFormula.Factory.newInstance();
        f.setStringValue(formula);
        this.cell.setF(f);
        if (this.cell.isSetV()) {
            this.cell.unsetV();
        }
    }

    public int getColumnIndex() {
        return this.cellNum;
    }

    public int getRowIndex() {
        return this.row.getRowNum();
    }

    public String getReference() {
        return this.cell.getR();
    }

    public XSSFCellStyle getCellStyle() {
        long idx = this.cell.isSetS() ? this.cell.getS() : 0L;
        return this.stylesSource.getStyleAt((int)idx);
    }

    public void setCellStyle(CellStyle style) {
        if (style == null) {
            if (this.cell.isSetS()) {
                this.cell.unsetS();
            }
        } else {
            XSSFCellStyle xStyle = (XSSFCellStyle)style;
            xStyle.verifyBelongsToStylesSource(this.stylesSource);
            long idx = this.stylesSource.putStyle(xStyle);
            this.cell.setS(idx);
        }
    }

    public int getCellType() {
        if (this.cell.getF() != null) {
            return 2;
        }
        return this.getBaseCellType(true);
    }

    public int getCachedFormulaResultType() {
        if (this.cell.getF() == null) {
            throw new IllegalStateException("Only formula cells have cached results");
        }
        return this.getBaseCellType(false);
    }

    private int getBaseCellType(boolean blankCells) {
        switch (this.cell.getT().intValue()) {
            case 1: {
                return 4;
            }
            case 2: {
                if (!this.cell.isSetV() && blankCells) {
                    return 3;
                }
                return 0;
            }
            case 3: {
                return 5;
            }
            case 4: 
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalStateException("Illegal cell type: " + this.cell.getT());
    }

    public Date getDateCellValue() {
        int cellType = this.getCellType();
        if (cellType == 3) {
            return null;
        }
        double value = this.getNumericCellValue();
        boolean date1904 = this.getSheet().getWorkbook().isDate1904();
        return DateUtil.getJavaDate((double)value, (boolean)date1904);
    }

    public void setCellValue(Date value) {
        boolean date1904 = this.getSheet().getWorkbook().isDate1904();
        this.setCellValue(DateUtil.getExcelDate((Date)value, (boolean)date1904));
    }

    public void setCellValue(Calendar value) {
        boolean date1904 = this.getSheet().getWorkbook().isDate1904();
        this.setCellValue(DateUtil.getExcelDate((Calendar)value, (boolean)date1904));
    }

    public String getErrorCellString() {
        int cellType = this.getCellType();
        if (cellType != 5) {
            throw XSSFCell.typeMismatch(5, cellType, false);
        }
        return this.cell.getV();
    }

    public byte getErrorCellValue() {
        String code = this.getErrorCellString();
        if (code == null) {
            return 0;
        }
        return FormulaError.forString((String)code).getCode();
    }

    public void setCellErrorValue(byte errorCode) {
        FormulaError error = FormulaError.forInt((byte)errorCode);
        this.setCellErrorValue(error);
    }

    public void setCellErrorValue(FormulaError error) {
        this.cell.setT(STCellType.E);
        this.cell.setV(error.getString());
    }

    public void setAsActiveCell() {
        this.getSheet().setActiveCell(this.cell.getR());
    }

    private void setBlank() {
        CTCell blank = CTCell.Factory.newInstance();
        blank.setR(this.cell.getR());
        blank.setS(this.cell.getS());
        this.cell.set((XmlObject)blank);
    }

    protected void setCellNum(int num) {
        XSSFCell.checkBounds(num);
        this.cellNum = num;
        String ref = new CellReference(this.getRowIndex(), this.getColumnIndex()).formatAsString();
        this.cell.setR(ref);
    }

    protected static short parseCellNum(String r) {
        if ((r = r.split("\\d+")[0]).length() == 1) {
            return (short)(r.charAt(0) - 65);
        }
        return (short)(r.charAt(1) - 65 + 26 * (r.charAt(0) - 64));
    }

    public void setCellType(int cellType) {
        int prevType = this.getCellType();
        switch (cellType) {
            case 3: {
                this.setBlank();
                break;
            }
            case 4: {
                String newVal = this.convertCellValueToBoolean() ? TRUE_AS_STRING : FALSE_AS_STRING;
                this.cell.setT(STCellType.B);
                this.cell.setV(newVal);
                break;
            }
            case 0: {
                this.cell.setT(STCellType.N);
                break;
            }
            case 5: {
                this.cell.setT(STCellType.E);
                break;
            }
            case 1: {
                if (prevType != 1) {
                    String str = this.convertCellValueToString();
                    XSSFRichTextString rt = new XSSFRichTextString(str);
                    rt.setStylesTableReference(this.stylesSource);
                    int sRef = this.sharedStringSource.addEntry(rt.getCTRst());
                    this.cell.setV(Integer.toString(sRef));
                }
                this.cell.setT(STCellType.S);
                break;
            }
            case 2: {
                if (this.cell.isSetF()) break;
                CTCellFormula f = CTCellFormula.Factory.newInstance();
                f.setStringValue(FALSE_AS_STRING);
                this.cell.setF(f);
                if (!this.cell.isSetT()) break;
                this.cell.unsetT();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal cell type: " + cellType);
            }
        }
    }

    public String toString() {
        switch (this.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 5: {
                return ErrorEval.getText((int)this.getErrorCellValue());
            }
            case 2: {
                return this.getCellFormula();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)this)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
                    return sdf.format(this.getDateCellValue());
                }
                return this.getNumericCellValue() + "";
            }
            case 1: {
                return this.getRichStringCellValue().toString();
            }
        }
        return "Unknown Cell Type: " + this.getCellType();
    }

    public String getRawValue() {
        return this.cell.getV();
    }

    private static String getCellTypeName(int cellTypeCode) {
        switch (cellTypeCode) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + cellTypeCode + ")#";
    }

    private static RuntimeException typeMismatch(int expectedTypeCode, int actualTypeCode, boolean isFormulaCell) {
        String msg = "Cannot get a " + XSSFCell.getCellTypeName(expectedTypeCode) + " value from a " + XSSFCell.getCellTypeName(actualTypeCode) + " " + (isFormulaCell ? "formula " : "") + "cell";
        return new IllegalStateException(msg);
    }

    private static void checkBounds(int cellIndex) {
        SpreadsheetVersion v = SpreadsheetVersion.EXCEL2007;
        int maxcol = SpreadsheetVersion.EXCEL2007.getLastColumnIndex();
        if (cellIndex < 0 || cellIndex > maxcol) {
            throw new IllegalArgumentException("Invalid column index (" + cellIndex + ").  Allowable column range for " + v.name() + " is (0.." + maxcol + ") or ('A'..'" + v.getLastColumnName() + "')");
        }
    }

    public XSSFComment getCellComment() {
        return this.getSheet().getCellComment(this.row.getRowNum(), this.getColumnIndex());
    }

    public void setCellComment(Comment comment) {
        String cellRef = new CellReference(this.row.getRowNum(), this.getColumnIndex()).formatAsString();
        this.getSheet().setCellComment(cellRef, (XSSFComment)comment);
    }

    public XSSFHyperlink getHyperlink() {
        return this.getSheet().getHyperlink(this.row.getRowNum(), this.cellNum);
    }

    public void setHyperlink(Hyperlink hyperlink) {
        XSSFHyperlink link = (XSSFHyperlink)hyperlink;
        link.setCellReference(new CellReference(this.row.getRowNum(), this.cellNum).formatAsString());
        this.getSheet().setCellHyperlink(link);
    }

    public CTCell getCTCell() {
        return this.cell;
    }

    private boolean convertCellValueToBoolean() {
        int cellType = this.getCellType();
        if (cellType == 2) {
            cellType = this.getBaseCellType(false);
        }
        switch (cellType) {
            case 4: {
                return TRUE_AS_STRING.equals(this.cell.getV());
            }
            case 1: {
                int sstIndex = Integer.parseInt(this.cell.getV());
                XSSFRichTextString rt = new XSSFRichTextString(this.sharedStringSource.getEntryAt(sstIndex));
                String text = rt.getString();
                return Boolean.valueOf(text);
            }
            case 0: {
                return Double.parseDouble(this.cell.getV()) != 0.0;
            }
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected cell type (" + cellType + ")");
    }

    private String convertCellValueToString() {
        int cellType = this.getCellType();
        switch (cellType) {
            case 3: {
                return "";
            }
            case 4: {
                return TRUE_AS_STRING.equals(this.cell.getV()) ? "TRUE" : "FALSE";
            }
            case 1: {
                int sstIndex = Integer.parseInt(this.cell.getV());
                XSSFRichTextString rt = new XSSFRichTextString(this.sharedStringSource.getEntryAt(sstIndex));
                return rt.getString();
            }
            case 0: {
                return String.valueOf(Double.parseDouble(this.cell.getV()));
            }
            case 5: {
                return this.cell.getV();
            }
            case 2: {
                return "";
            }
        }
        throw new RuntimeException("Unexpected cell type (" + cellType + ")");
    }
}

