/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.fragments.FragmentType;
import org.nuxeo.theme.html.CSSUtils;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.views.TemplateView;
import org.nuxeo.theme.views.ViewType;

public class HTMLView
extends TemplateView {
    private static final Log log = LogFactory.getLog(HTMLView.class);
    private static final Pattern firstTagPattern = Pattern.compile("<([a-zA-Z0-9:]*)[^>]*>", 32);
    private static final String[] ALLOWED_TAGS = new String[]{"html", "body", "table", "tr", "td", "div"};

    /*
     * Enabled aggressive block sorting
     */
    public String render(RenderingInfo info) {
        String cssClassName;
        ViewType viewType = this.getViewType();
        String template = viewType.getTemplate();
        String result = this.getTemplateContent(template);
        Matcher matcher = firstTagPattern.matcher(result);
        if (matcher.find()) {
            String tag = matcher.group(1).toLowerCase();
            boolean found = false;
            for (String allowedTag : ALLOWED_TAGS) {
                if (!tag.equals(allowedTag)) continue;
                found = true;
            }
            if (found) {
                // empty if block
            }
        } else {
            log.warn((Object)("First HTML tag of view template: " + template + " not found"));
        }
        Element element = info.getElement();
        if (element instanceof Fragment) {
            Fragment fragment = (Fragment)element;
            if (!info.isDirty() && this.hasModelExpressions(result)) {
                FragmentType fragmentType = fragment.getFragmentType();
                String fragmentTypeName = fragmentType.getTypeName();
                log.warn((Object)String.format("Cannot render \"%s\" with the view \"%s\" because the view's template contains a 'nxthemesInfo' variable and the fragment type is not declared as dynamic. Try to add <dynamic>true</dynamic> in the <fragment name=\"%s\"> definition.", fragmentTypeName, this.getViewType().getViewName(), fragmentTypeName));
                return "";
            }
            result = this.replaceModelExpressions(info, result);
        }
        if ((cssClassName = element.getCssClassName()) == null) return result.replace("[nxthemes markup]", info.getMarkup());
        result = CSSUtils.insertCssClass(result, cssClassName);
        return result.replace("[nxthemes markup]", info.getMarkup());
    }

    public String replaceModelExpressions(RenderingInfo info, String html) {
        return html;
    }

    public boolean hasModelExpressions(String html) {
        return html.contains("nxthemesInfo");
    }
}

