/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.impl.AbstractRunner;
import org.nuxeo.ecm.platform.routing.core.impl.ElementRunner;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.runtime.api.Framework;

public class GraphRunner
extends AbstractRunner
implements ElementRunner {
    private static final Log log = LogFactory.getLog(GraphRunner.class);
    public static final int MAX_LOOPS = 100;

    @Override
    public void run(CoreSession session, DocumentRouteElement element, Map<String, Serializable> map) {
        try {
            boolean done;
            GraphRoute graph = (GraphRoute)element;
            element.setRunning(session);
            if (map != null) {
                graph.setVariables(map);
            }
            if (done = this.runGraph(session, graph, graph.getStartNode())) {
                element.setDone(session);
            }
            session.save();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void run(CoreSession session, DocumentRouteElement element) {
        this.run(session, element, null);
    }

    @Override
    public void resume(CoreSession session, DocumentRouteElement element, String nodeId, String taskId, Map<String, Object> varData, String status) {
        try {
            boolean done;
            boolean forceResume;
            GraphNode node;
            GraphRoute graph = (GraphRoute)element;
            Task task = null;
            if (taskId == null) {
                if (nodeId == null) {
                    throw new DocumentRouteException("nodeId and taskId both missing");
                }
            } else {
                DocumentModel taskDoc = session.getDocument((DocumentRef)new IdRef(taskId));
                task = (Task)taskDoc.getAdapter(Task.class);
                if (task == null) {
                    throw new DocumentRouteException("Invalid taskId: " + taskId);
                }
                if (nodeId == null && StringUtils.isEmpty((String)(nodeId = task.getVariable("nodeId")))) {
                    throw new DocumentRouteException("No nodeId found on task: " + taskId);
                }
            }
            if ((node = graph.getNode(nodeId)) == null) {
                throw new DocumentRouteException("Invalid nodeId: " + nodeId);
            }
            boolean bl = forceResume = varData != null && varData.get("_FORCE_RESUME_") != null && (Boolean)varData.get("_FORCE_RESUME_") != false;
            if (forceResume && node.getState() != GraphNode.State.SUSPENDED && node.getState() != GraphNode.State.WAITING) {
                throw new DocumentRouteException("Cannot force resume on non-suspended or non-waiting node: " + node);
            }
            if (!forceResume && node.getState() != GraphNode.State.SUSPENDED) {
                throw new DocumentRouteException("Cannot resume on non-suspended node: " + node);
            }
            node.setAllVariables(varData);
            if (StringUtils.isNotEmpty((String)status)) {
                node.setButton(status);
            }
            if (task != null) {
                this.finishTask(session, graph, node, task, false);
            }
            if (done = this.runGraph(session, graph, node)) {
                element.setDone(session);
            }
            session.save();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void cancel(CoreSession session, DocumentRouteElement element) {
        super.cancel(session, element);
        if (!(element instanceof GraphRoute)) {
            return;
        }
        TaskService taskService = (TaskService)Framework.getLocalService(TaskService.class);
        try {
            GraphRoute graph = (GraphRoute)element;
            List tasks = taskService.getAllTaskInstances(element.getDocument().getId(), session);
            for (Task task : tasks) {
                GraphNode node;
                String nodeId = task.getVariable("nodeId");
                if (StringUtils.isEmpty((String)nodeId)) {
                    log.error((Object)("Task has no nodeId: " + task));
                    continue;
                }
                try {
                    node = graph.getNode(nodeId);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Graph has no nodeId: " + nodeId));
                    continue;
                }
                this.finishTask(session, graph, node, task, true);
            }
            session.save();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected boolean runGraph(CoreSession session, GraphRoute graph, GraphNode initialNode) throws DocumentRouteException {
        LinkedList<GraphNode> pendingNodes = new LinkedList<GraphNode>();
        pendingNodes.add(initialNode);
        boolean done = false;
        int count = 0;
        while (!pendingNodes.isEmpty()) {
            GraphNode node = (GraphNode)pendingNodes.pop();
            if (++count > 100) {
                throw new DocumentRouteException("Execution is looping, node: " + node);
            }
            GraphNode.State jump = null;
            switch (node.getState()) {
                case READY: {
                    log.debug((Object)("Doing node " + node));
                    if (node.isMerge()) {
                        jump = GraphNode.State.WAITING;
                        break;
                    }
                    jump = GraphNode.State.RUNNING_INPUT;
                    break;
                }
                case WAITING: {
                    if (!node.canMerge()) break;
                    this.recursiveCancelInput(graph, node, pendingNodes);
                    jump = GraphNode.State.RUNNING_INPUT;
                    break;
                }
                case RUNNING_INPUT: {
                    node.starting();
                    node.executeChain(node.getInputChain());
                    if (node.hasTask()) {
                        this.createTask(session, graph, node);
                        node.setState(GraphNode.State.SUSPENDED);
                        break;
                    }
                    jump = GraphNode.State.RUNNING_OUTPUT;
                    break;
                }
                case SUSPENDED: {
                    if (node != initialNode) {
                        throw new DocumentRouteException("Executing unexpected SUSPENDED state");
                    }
                    NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
                    String actor = principal.getOriginatingUser();
                    if (actor == null) {
                        actor = principal.getName();
                    }
                    node.setLastActor(actor);
                    jump = GraphNode.State.RUNNING_OUTPUT;
                    break;
                }
                case RUNNING_OUTPUT: {
                    node.executeChain(node.getOutputChain());
                    List<GraphNode.Transition> trueTrans = node.evaluateTransitions();
                    node.ending();
                    node.setState(GraphNode.State.READY);
                    if (node.isStop()) {
                        if (!pendingNodes.isEmpty()) {
                            throw new DocumentRouteException(String.format("Route %s stopped with still pending nodes: %s", graph, pendingNodes));
                        }
                        done = true;
                        break;
                    }
                    if (trueTrans.isEmpty()) {
                        throw new DocumentRouteException("No transition evaluated to true from node " + node);
                    }
                    for (GraphNode.Transition t : trueTrans) {
                        node.executeTransitionChain(t);
                        GraphNode target = graph.getNode(t.target);
                        if (pendingNodes.contains(target)) continue;
                        pendingNodes.add(target);
                    }
                    break;
                }
            }
            if (jump == null) continue;
            node.setState(jump);
            --count;
            pendingNodes.addFirst(node);
        }
        return done;
    }

    protected void recursiveCancelInput(GraphRoute graph, GraphNode originalNode, LinkedList<GraphNode> pendingNodes) {
        LinkedList<GraphNode> todo = new LinkedList<GraphNode>();
        todo.add(originalNode);
        HashSet<String> done = new HashSet<String>();
        while (!todo.isEmpty()) {
            GraphNode node = (GraphNode)todo.pop();
            done.add(node.getId());
            for (GraphNode.Transition t : node.getInputTransitions()) {
                GraphNode source;
                if (t.loop || done.contains((source = t.source).getId())) continue;
                source.setCanceled();
                GraphNode.State state = source.getState();
                source.setState(GraphNode.State.READY);
                pendingNodes.remove(node);
                if (state == GraphNode.State.SUSPENDED) {
                    source.cancelTasks();
                    continue;
                }
                todo.add(source);
            }
        }
    }

    protected void createTask(CoreSession session, GraphRoute graph, GraphNode node) throws DocumentRouteException {
        DocumentRouteElement routeInstance = (DocumentRouteElement)graph;
        HashMap<String, String> taskVariables = new HashMap<String, String>();
        taskVariables.put("routeInstanceDocId", routeInstance.getDocument().getId());
        taskVariables.put("nodeId", node.getId());
        taskVariables.put("document.routing.step", node.getDocument().getId());
        String taskNotiftemplate = node.getTaskNotificationTemplate();
        if (!StringUtils.isEmpty((String)taskNotiftemplate)) {
            taskVariables.put("taskNotificationTemplate", taskNotiftemplate);
        } else {
            taskVariables.put("disableNotificationService", "true");
        }
        LinkedHashSet<String> actors = new LinkedHashSet<String>();
        actors.addAll(node.evaluateTaskAssignees());
        actors.addAll(node.getTaskAssignees());
        Date dueDate = node.computeTaskDueDate();
        DocumentModelList docs = graph.getAttachedDocumentModels();
        try {
            TaskService taskService = (TaskService)Framework.getLocalService(TaskService.class);
            DocumentRoutingService routing = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
            DocumentModel doc = docs.size() > 0 ? (DocumentModel)docs.get(0) : null;
            List tasks = taskService.createTask(session, (NuxeoPrincipal)session.getPrincipal(), doc, node.getTaskDocType(), node.getDocument().getTitle(), node.getId(), routeInstance.getDocument().getId(), new ArrayList(actors), false, node.getTaskDirective(), null, dueDate, taskVariables, null, node.getWorkflowContextualInfo(true));
            routing.makeRoutingTasks(session, tasks);
            String taskAssigneesPermission = node.getTaskAssigneesPermission();
            if (StringUtils.isEmpty((String)taskAssigneesPermission)) {
                return;
            }
            for (Task task : tasks) {
                routing.grantPermissionToTaskAssignees(session, taskAssigneesPermission, (List)docs, task);
            }
        }
        catch (ClientException e) {
            throw new DocumentRouteException("Can not create task", (Throwable)e);
        }
    }

    protected void finishTask(CoreSession session, GraphRoute graph, GraphNode node, Task task, boolean delete) throws DocumentRouteException {
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        routing.finishTask(session, (DocumentRoute)graph, task, delete);
    }
}

