/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.util.Locale;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;

class NodeView {
    public int x;
    public int y;
    public boolean isStartNode;
    public boolean isEndNode;
    public String id;
    public String title;
    public String state;

    public NodeView(GraphNode node, Locale locale) throws ClientException {
        this.x = Integer.parseInt((String)((Object)node.getDocument().getPropertyValue("rnode:taskX")));
        this.y = Integer.parseInt((String)((Object)node.getDocument().getPropertyValue("rnode:taskY")));
        this.isEndNode = node.isStart();
        this.isEndNode = node.isStop();
        this.id = node.getId();
        String titleProp = (String)((Object)node.getDocument().getPropertyValue("dc:title"));
        this.title = this.getI18nLabel(titleProp, locale);
        this.state = node.getDocument().getCurrentLifeCycleState();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isStartNode() {
        return this.isStartNode;
    }

    public boolean isEndNode() {
        return this.isEndNode;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getState() {
        return this.state;
    }

    protected String getI18nLabel(String label, Locale locale) {
        if (label == null) {
            label = "";
        }
        return I18NUtils.getMessageString((String)"messages", (String)label, null, (Locale)locale);
    }
}

