/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.web;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.In;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

public abstract class AbstractPublishActions {
    private static final Log log = LogFactory.getLog(AbstractPublishActions.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;

    public String getFormattedPath(DocumentModel documentModel) throws ClientException {
        ArrayList<String> pathFragments = new ArrayList<String>();
        this.getPathFragments(documentModel, pathFragments);
        return AbstractPublishActions.formatPathFragments(pathFragments);
    }

    protected static String formatPathFragments(List<String> pathFragments) {
        String fullPath = "";
        for (String aFragment : pathFragments) {
            if (!"".equals(fullPath)) {
                fullPath = ">" + fullPath;
            }
            fullPath = aFragment + fullPath;
        }
        return fullPath;
    }

    protected void getPathFragments(DocumentModel documentModel, List<String> pathFragments) throws ClientException {
        String pathElementName = documentModel.getTitle();
        String translatedPathElement = (String)this.resourcesAccessor.getMessages().get(pathElementName);
        pathFragments.add(translatedPathElement);
        if ("Domain".equals(documentModel.getType())) {
            return;
        }
        if (this.documentManager.hasPermission(documentModel.getParentRef(), "Read")) {
            DocumentModel parentDocument = this.documentManager.getDocument(documentModel.getParentRef());
            this.getPathFragments(parentDocument, pathFragments);
        }
    }
}

