/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.uidgen.service;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.ecm.platform.uidgen.UIDSequencer;
import org.nuxeo.ecm.platform.uidgen.ejb.UIDSequenceBean;
import org.nuxeo.runtime.api.Framework;

public class UIDSequencerImpl
implements UIDSequencer {
    private static volatile PersistenceProvider persistenceProvider;

    public static void dispose() {
        UIDSequencerImpl.deactivatePersistenceProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PersistenceProvider getOrCreatePersistenceProvider() {
        if (persistenceProvider != null) return persistenceProvider;
        Class<UIDSequencerImpl> clazz = UIDSequencerImpl.class;
        synchronized (UIDSequencerImpl.class) {
            if (persistenceProvider != null) return persistenceProvider;
            UIDSequencerImpl.activatePersistenceProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return persistenceProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void activatePersistenceProvider() {
        Thread thread = Thread.currentThread();
        ClassLoader last = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(PersistenceProvider.class.getClassLoader());
            PersistenceProviderFactory persistenceProviderFactory = (PersistenceProviderFactory)Framework.getLocalService(PersistenceProviderFactory.class);
            persistenceProvider = persistenceProviderFactory.newProvider("NXUIDSequencer");
            persistenceProvider.openPersistenceUnit();
        }
        finally {
            thread.setContextClassLoader(last);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void deactivatePersistenceProvider() {
        if (persistenceProvider == null) return;
        Class<UIDSequencerImpl> clazz = UIDSequencerImpl.class;
        synchronized (UIDSequencerImpl.class) {
            if (persistenceProvider == null) return;
            persistenceProvider.closePersistenceUnit();
            persistenceProvider = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int getNext(final String key) {
        try {
            return (Integer)UIDSequencerImpl.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Integer>(){

                public Integer runWith(EntityManager em) {
                    return UIDSequencerImpl.this.getNext(em, key);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public int getNext(EntityManager em, String key) {
        UIDSequenceBean seq;
        try {
            seq = (UIDSequenceBean)em.createNamedQuery("UIDSequence.findByKey").setParameter("key", (Object)key).getSingleResult();
        }
        catch (NoResultException e) {
            seq = new UIDSequenceBean(key);
            em.persist((Object)seq);
        }
        return seq.nextIndex();
    }
}

