/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.facelet;

import javax.servlet.ServletContext;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.mock.MockServletContext;

@Name(value="org.jboss.seam.ui.facelet.mockServletContext")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(dependencies={"org.jboss.seam.faces.renderer"})
@AutoCreate
public class ServletContextManager {
    private ServletContext servletContext;

    @Create
    public void create() {
        this.servletContext = ServletLifecycle.getServletContext() != null ? ServletLifecycle.getServletContext() : new MockServletContext();
    }

    @Unwrap
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public static ServletContext instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("Application context is not active");
        }
        return (ServletContext)Component.getInstance(ServletContextManager.class, (ScopeType)ScopeType.APPLICATION);
    }
}

