/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapper;

public class LockManager {
    private static final Log log = LogFactory.getLog(LockManager.class);
    protected final Mapper mapper;
    protected Connection connection;
    protected final boolean clusteringEnabled;
    protected final ReentrantLock serializationLock;
    protected static AtomicLong txCounter = new AtomicLong();
    protected static final Lock NULL_LOCK = new Lock(null, null);
    protected final boolean caching;
    protected final LRUCache<Serializable, Lock> lockCache;
    protected static final int CACHE_SIZE = 100;

    public LockManager(Mapper mapper, boolean clusteringEnabled) throws StorageException {
        this.mapper = mapper;
        this.connection = ((JDBCMapper)mapper).connection;
        this.clusteringEnabled = clusteringEnabled;
        this.serializationLock = new ReentrantLock(true);
        this.caching = !clusteringEnabled;
        this.lockCache = this.caching ? new LRUCache(100) : null;
        try {
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws StorageException {
        this.serializationLock.lock();
        try {
            this.mapper.close();
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock getLock(Serializable id) throws StorageException {
        this.serializationLock.lock();
        try {
            Lock lock;
            if (this.caching && (lock = (Lock)this.lockCache.get(id)) != null) {
                Lock lock2 = lock == NULL_LOCK ? null : lock;
                return lock2;
            }
            lock = this.mapper.getLock(id);
            if (this.caching) {
                this.lockCache.put(id, lock == null ? NULL_LOCK : lock);
            }
            Lock lock3 = lock;
            return lock3;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public Lock setLock(Serializable id, Lock lock) throws StorageException {
        int RETRIES = 10;
        long sleepDelay = 1L;
        long INCREMENT = 50L;
        for (int i = 0; i < RETRIES; ++i) {
            if (i > 0) {
                log.debug((Object)("Retrying lock on " + id + ": try " + (i + 1)));
            }
            try {
                return this.setLockInternal(id, lock);
            }
            catch (StorageException e) {
                Throwable c = e.getCause();
                if (c != null && c instanceof SQLException && this.shouldRetry((SQLException)c)) {
                    try {
                        Thread.sleep(sleepDelay);
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                    sleepDelay += INCREMENT;
                    continue;
                }
                throw e;
            }
        }
        throw new StorageException("Failed to lock " + id + ", too much concurrency (tried " + RETRIES + " times)");
    }

    protected boolean shouldRetry(SQLException e) {
        String sqlState = e.getSQLState();
        if ("23000".equals(sqlState)) {
            return true;
        }
        if ("23001".equals(sqlState)) {
            return true;
        }
        if ("23505".equals(sqlState)) {
            return true;
        }
        return "S0003".equals(sqlState) || "S0005".equals(sqlState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock setLockInternal(final Serializable id, final Lock lock) throws StorageException {
        this.serializationLock.lock();
        try {
            Lock oldLock;
            if (this.caching && (oldLock = (Lock)this.lockCache.get(id)) != null && oldLock != NULL_LOCK) {
                Lock lock2 = oldLock;
                return lock2;
            }
            oldLock = this.callInTransaction(new Callable<Lock>(){

                @Override
                public Lock call() throws Exception {
                    return LockManager.this.mapper.setLock(id, lock);
                }
            });
            if (this.caching && oldLock == null) {
                this.lockCache.put(id, lock == null ? NULL_LOCK : lock);
            }
            Lock lock3 = oldLock;
            return lock3;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock removeLock(final Serializable id, final String owner) throws StorageException {
        this.serializationLock.lock();
        try {
            Lock oldLock = null;
            if (this.caching && (oldLock = (Lock)this.lockCache.get(id)) == NULL_LOCK) {
                Lock lock = null;
                return lock;
            }
            if (oldLock != null && !LockManager.canLockBeRemoved(oldLock, owner)) {
                oldLock = new Lock(oldLock, true);
            } else if (oldLock == null) {
                oldLock = this.callInTransaction(new Callable<Lock>(){

                    @Override
                    public Lock call() throws Exception {
                        return LockManager.this.mapper.removeLock(id, owner, false);
                    }
                });
            } else {
                this.mapper.removeLock(id, owner, true);
            }
            if (this.caching) {
                if (oldLock != null && oldLock.getFailed()) {
                    this.lockCache.put(id, new Lock(oldLock, false));
                } else {
                    this.lockCache.put(id, NULL_LOCK);
                }
            }
            Lock lock = oldLock;
            return lock;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock callInTransaction(Callable<Lock> callable) throws StorageException {
        boolean tx = this.clusteringEnabled;
        boolean ok = false;
        try {
            Lock result;
            if (tx) {
                try {
                    this.connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new StorageException(e);
                }
            }
            try {
                result = callable.call();
            }
            catch (StorageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new StorageException(e);
            }
            ok = true;
            Lock lock = result;
            return lock;
        }
        finally {
            if (tx) {
                try {
                    try {
                        if (ok) {
                            this.connection.commit();
                        } else {
                            this.connection.rollback();
                        }
                    }
                    catch (SQLException e) {
                        throw new StorageException(e);
                    }
                }
                finally {
                    try {
                        this.connection.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        throw new StorageException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        this.serializationLock.lock();
        try {
            if (this.caching) {
                this.lockCache.clear();
            }
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public static boolean canLockBeRemoved(Lock lock, String owner) {
        return owner == null || owner.equals(lock.getOwner());
    }

    protected static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int max;

        public LRUCache(int max) {
            super(max, 1.0f, true);
            this.max = max;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.max;
        }
    }
}

