/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.CollectionProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBaseProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

public class SQLCollectionProperty
extends SQLBaseProperty {
    private final CollectionProperty property;
    private final boolean isArray;
    private final SQLSession session;

    public SQLCollectionProperty(SQLSession session, CollectionProperty property, ListType type, boolean readonly) {
        super((Type)type, property == null ? null : property.getName(), readonly);
        this.session = session;
        this.property = property;
        this.isArray = type == null || type.isArray();
    }

    public String getName() {
        return this.property.getName();
    }

    public Object getValue() throws DocumentException {
        try {
            Serializable[] value = this.property.getValue();
            if (this.isArray) {
                return value;
            }
            return new ArrayList<Serializable>(Arrays.asList(value));
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public void setValue(Object value) throws DocumentException {
        this.checkWritable();
        if ("ecm:acl".equals(this.property.getName())) {
            this.session.requireReadAclsUpdate();
        }
        if (value != null && !(value instanceof Object[])) {
            if (this.isArray) {
                throw new DocumentException("Value is not Object[] but " + value.getClass().getName() + ": " + value);
            }
            if (!(value instanceof Collection)) {
                throw new DocumentException("Value is not Object[] or Collection but " + value.getClass().getName() + ": " + value);
            }
            value = this.property.type.getArrayBaseType().collectionToArray((Collection)value);
        }
        try {
            this.property.setValue(value);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }
}

