/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import org.nuxeo.ecm.core.api.WrappedException;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.InvalidationsQueue;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SoftRefCachingRowMapper;
import org.nuxeo.ecm.core.storage.sql.net.MapperClientInfo;

public class MapperInvoker
extends Thread {
    private static final String INVOKER_INIT = "__init";
    private static final String INVOKER_CLOSE = "__close";
    private static final Map<String, Method> mapperMethods = new HashMap<String, Method>();
    private final Repository repository;
    private final InvalidationsQueue eventQueue;
    private Session session;
    private Mapper mapper;
    protected MapperClientInfo clientInfo;
    protected final SynchronousQueue<MethodCall> methodCalls;

    public MapperInvoker(Repository repository, String name, InvalidationsQueue eventQueue, MapperClientInfo info) throws Throwable {
        super(name);
        this.repository = repository;
        this.eventQueue = eventQueue;
        this.methodCalls = new SynchronousQueue();
        this.clientInfo = info;
    }

    public void init() throws Throwable {
        this.call(INVOKER_INIT, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Throwable {
        try {
            this.call(INVOKER_CLOSE, new Object[0]);
        }
        finally {
            this.interrupt();
            this.join();
        }
    }

    public Object call(String methodName, Object ... args) throws Throwable {
        MethodCall call = new MethodCall(methodName, args);
        this.methodCalls.put(call);
        return call.getResult();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Object res;
                MethodCall call = this.methodCalls.take();
                try {
                    res = this.localCall(call.methodName, call.args);
                }
                catch (InvocationTargetException e) {
                    res = WrappedException.wrap((Throwable)e.getCause());
                }
                catch (Exception e) {
                    res = WrappedException.wrap((Throwable)e);
                }
                call.setResult(res);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected Object localCall(String methodName, Object[] args) throws Exception {
        if (INVOKER_INIT.equals(methodName)) {
            this.session = this.repository.getConnection();
            this.mapper = this.session.getMapper();
            if (this.mapper instanceof SoftRefCachingRowMapper) {
                ((SoftRefCachingRowMapper)((Object)this.mapper)).setEventQueue(this.eventQueue);
            }
            return null;
        }
        if (INVOKER_CLOSE.equals(methodName)) {
            this.session.close();
            this.mapper = null;
            return null;
        }
        if ("close".equals(methodName)) {
            return null;
        }
        Method method = mapperMethods.get(methodName);
        if (method == null) {
            throw new StorageException("Unknown Mapper method: " + methodName);
        }
        return method.invoke((Object)this.mapper, args);
    }

    static {
        for (Method m : Mapper.class.getMethods()) {
            mapperMethods.put(m.getName(), m);
        }
    }

    protected static final class MethodCall {
        public final String methodName;
        public final Object[] args;
        protected final CountDownLatch resultReady;
        protected Object result;

        public MethodCall(String methodName, Object[] args) {
            this.methodName = methodName;
            this.args = args;
            this.resultReady = new CountDownLatch(1);
        }

        public void setResult(Object result) {
            this.result = result;
            this.resultReady.countDown();
        }

        public Object getResult() throws InterruptedException {
            this.resultReady.await();
            return this.result;
        }
    }
}

