/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.InvalidationsQueue;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryResolver;
import org.nuxeo.ecm.core.storage.sql.net.MapperClient;
import org.nuxeo.ecm.core.storage.sql.net.MapperClientInfo;
import org.nuxeo.ecm.core.storage.sql.net.MapperInvoker;
import org.nuxeo.ecm.core.storage.sql.net.OutputStreamToWriter;

public class MapperServlet
extends HttpServlet {
    public static final String SERVER_THREAD_NAME_PREFIX = "Nuxeo-VCS-Server-";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MapperServlet.class);
    public static final String PARAM_RID = "rid";
    public static final String PARAM_MID = "mid";
    private final AtomicLong repositoryCounter = new AtomicLong(0L);
    private final String repositoryName;
    private Repository repository;
    private final Map<String, InvalidationsQueue> eventQueues;
    private boolean initialized;
    private Map<String, MapperInvoker> invokers;
    private final AtomicInteger threadNumber = new AtomicInteger();

    public MapperServlet(String repositoryName) {
        this.repositoryName = repositoryName;
        this.eventQueues = Collections.synchronizedMap(new HashMap());
    }

    public static String getName(String repositoryName) {
        return MapperServlet.class.getSimpleName() + '-' + repositoryName;
    }

    protected synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.repository = RepositoryResolver.getRepository(this.repositoryName);
        this.invokers = Collections.synchronizedMap(new HashMap());
    }

    public void destroy() {
        if (this.invokers != null) {
            for (Map.Entry<String, MapperInvoker> es : this.invokers.entrySet()) {
                MapperInvoker invoker = es.getValue();
                try {
                    invoker.call("close", new Object[0]);
                    invoker.close();
                }
                catch (Throwable e) {
                    log.error((Object)("Cannot close invoker " + es.getKey()));
                }
            }
        }
        super.destroy();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String mid;
        this.initialize();
        String rid = req.getParameter(PARAM_RID);
        if (rid == null || "".equals(rid)) {
            rid = "" + this.repositoryCounter.incrementAndGet();
        }
        if ("".equals(mid = req.getParameter(PARAM_MID))) {
            mid = null;
        }
        ServletInputStream is = req.getInputStream();
        try {
            Object object;
            MapperInvoker invoker;
            if (mid == null) {
                String name = SERVER_THREAD_NAME_PREFIX + this.threadNumber.incrementAndGet();
                InvalidationsQueue eventQueue = this.eventQueues.get(rid);
                if (eventQueue == null) {
                    eventQueue = new InvalidationsQueue("servlet-for-" + rid);
                    this.eventQueues.put(rid, eventQueue);
                }
                String remoteIP = req.getRemoteAddr();
                String remotePrincipal = req.getHeader("X-Nuxeo-Principal");
                invoker = new MapperInvoker(this.repository, name, eventQueue, new MapperClientInfo(remoteIP, remotePrincipal));
                Mapper.Identification id = (Mapper.Identification)invoker.call("getIdentification", new Object[0]);
                mid = id.mapperId;
                this.invokers.put(mid, invoker);
            } else {
                invoker = this.invokers.get(mid);
                if (invoker == null) {
                    throw new RuntimeException("Unknown session id (maybe timed out): " + mid);
                }
            }
            invoker.clientInfo.handledRequest(req);
            resp.setContentType("application/octet-stream");
            PrintWriter writer = resp.getWriter();
            ObjectOutputStream oos = new ObjectOutputStream(new OutputStreamToWriter(writer));
            ObjectInputStream ois = new ObjectInputStream((InputStream)is);
            String methodName = (String)ois.readObject();
            LinkedList<Object> args = new LinkedList<Object>();
            while ((object = ois.readObject()) != MapperClient.EOF) {
                args.add(object);
            }
            Object res = invoker.call(methodName, args.toArray());
            if ("close".equals(methodName)) {
                invoker.close();
                this.invokers.remove(mid);
            } else if ("getIdentification".equals(methodName)) {
                Mapper.Identification id = (Mapper.Identification)res;
                res = new Mapper.Identification(rid, id.mapperId);
            }
            oos.writeObject(res);
            oos.flush();
            oos.close();
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            resp.sendError(500, e.toString());
        }
    }

    public Collection<MapperClientInfo> getClientInfos() {
        if (this.invokers == null) {
            return Collections.emptyList();
        }
        ArrayList<MapperClientInfo> infos = new ArrayList<MapperClientInfo>(this.invokers.size());
        for (MapperInvoker invoker : this.invokers.values()) {
            infos.add(invoker.clientInfo);
        }
        return infos;
    }
}

