/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class OutputStreamToWriter
extends OutputStream {
    protected final Writer writer;
    private final StringBuilder sb = new StringBuilder();
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    public OutputStreamToWriter(Writer writer) {
        this.writer = writer;
    }

    private void dump(int ub) {
        if (ub <= 32 || ub >= 128) {
            this.sb.append("0x");
            this.sb.append(HEX_DIGITS[(0xF0 & ub) >> 4]);
            this.sb.append(HEX_DIGITS[0xF & ub]);
        } else {
            this.sb.append((char)ub);
        }
        this.sb.append(' ');
    }

    private void flushDebug() {
        if (this.sb.length() > 0) {
            System.out.println("> " + this.sb.toString());
            this.sb.setLength(0);
        }
    }

    protected char getChar(byte b) {
        int ub = 0xFF & b;
        return (char)ub;
    }

    @Override
    public void write(int b) throws IOException {
        this.writer.write(this.getChar((byte)b));
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.writer.write(this.getChar(bytes[off + i]));
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

