/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.vocabularies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.platform.syndication.vocabularies.HierarchicalVocabulary;
import org.nuxeo.ecm.platform.syndication.vocabularies.SimpleVocabulary;
import org.w3c.dom.Element;

public final class Tree {
    private final List<HierarchicalVocabulary> rootNodes = new ArrayList<HierarchicalVocabulary>();

    private Tree(List<HierarchicalVocabulary> rootNodes) {
        this.rootNodes.addAll(rootNodes);
    }

    public String asXML() {
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument document = (DOMDocument)domfactory.createDocument();
        Element current = document.createElement("entries");
        document.setRootElement((org.dom4j.Element)current);
        Tree.buildXML(this.rootNodes, current, document);
        return document.asXML();
    }

    public void buildXML(DOMDocument document) {
        Element current = document.createElement("entries");
        document.setRootElement((org.dom4j.Element)current);
        Tree.buildXML(this.rootNodes, current, document);
    }

    private static void buildXML(List<HierarchicalVocabulary> nodes, Element currentElement, DOMDocument document) {
        for (HierarchicalVocabulary voca : nodes) {
            Element element = document.createElement("entry");
            element.setAttribute("id", voca.getVocabulary().getId());
            element.setAttribute("label", voca.getVocabulary().getLabel());
            element.setAttribute("translatedLabel", voca.getVocabulary().getTranslatedLabel());
            if (voca.hasParent()) {
                element.setAttribute("parent", voca.getParent().getVocabulary().getId());
            }
            if (voca.hasChildren()) {
                Tree.buildXML(voca.getChildren(), element, document);
            }
            currentElement.appendChild(element);
        }
    }

    public static final class Builder {
        private final Map<String, List<SimpleVocabulary>> pendingVocabularies = new HashMap<String, List<SimpleVocabulary>>();
        private final Map<String, HierarchicalVocabulary> mapVocabularies = new HashMap<String, HierarchicalVocabulary>();

        public void addElement(String parent, HierarchicalVocabulary parentVoca1, SimpleVocabulary voca) {
            if (null == parent) {
                HierarchicalVocabulary newVoca = new HierarchicalVocabulary(null, voca);
                this.addNewVocabulary(newVoca);
            } else {
                HierarchicalVocabulary parentVoca = this.mapVocabularies.get(parent.toLowerCase());
                if (null != parentVoca) {
                    HierarchicalVocabulary newVoca = new HierarchicalVocabulary(parentVoca, voca);
                    parentVoca.addChild(newVoca);
                    this.addNewVocabulary(newVoca);
                } else {
                    this.mapVocabularies.put(parent, parentVoca1);
                    this.addPendingVocabulary(parent, voca);
                }
            }
        }

        private void addNewVocabulary(HierarchicalVocabulary voca) {
            String id = voca.getVocabulary().getId().toLowerCase();
            this.mapVocabularies.put(id, voca);
            this.addWaitingChildren(voca);
        }

        private void addWaitingChildren(HierarchicalVocabulary voca) {
            String id = voca.getVocabulary().getId().toLowerCase();
            List<SimpleVocabulary> children = this.pendingVocabularies.remove(id);
            if (null != children) {
                for (SimpleVocabulary child : children) {
                    HierarchicalVocabulary newVoca = new HierarchicalVocabulary(voca, child);
                    voca.addChild(newVoca);
                }
            }
        }

        private void addPendingVocabulary(String parent, SimpleVocabulary dir) {
            List<SimpleVocabulary> dirs = this.pendingVocabularies.get(parent.toLowerCase());
            if (null == dirs) {
                dirs = new ArrayList<SimpleVocabulary>();
            }
            dirs.add(dir);
            this.pendingVocabularies.put(parent.toLowerCase(), dirs);
        }

        public Tree build() {
            ArrayList<HierarchicalVocabulary> rootNodes = new ArrayList<HierarchicalVocabulary>();
            HashMap<String, HierarchicalVocabulary> mV = new HashMap<String, HierarchicalVocabulary>();
            mV.putAll(this.mapVocabularies);
            for (String key : mV.keySet()) {
                this.addWaitingChildren(this.mapVocabularies.get(key));
            }
            for (HierarchicalVocabulary voca : this.mapVocabularies.values()) {
                HierarchicalVocabulary vp = this.getNode(voca);
                if (rootNodes.contains(vp)) continue;
                rootNodes.add(vp);
            }
            Collections.sort(rootNodes, HierarchicalVocabulary.ORDER_BY_ID);
            return new Tree(rootNodes);
        }

        public HierarchicalVocabulary getNode(HierarchicalVocabulary hv) {
            if (hv.getParent() == null) {
                return hv;
            }
            return this.getNode(hv.getParent());
        }
    }
}

