/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.Hyperlink;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.hslf.model.ShapePainter;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.record.InteractiveInfo;
import org.apache.poi.hslf.record.InteractiveInfoAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.util.LittleEndian;

public abstract class SimpleShape
extends Shape {
    protected Record[] _clientRecords;
    protected EscherClientDataRecord _clientData;

    protected SimpleShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherChildAnchorRecord anchor;
        this._escherContainer = new EscherContainerRecord();
        this._escherContainer.setRecordId((short)-4092);
        this._escherContainer.setOptions((short)15);
        EscherSpRecord sp = new EscherSpRecord();
        int flags = 2560;
        if (isChild) {
            flags |= 2;
        }
        sp.setFlags(flags);
        this._escherContainer.addChildRecord((EscherRecord)sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        this._escherContainer.addChildRecord((EscherRecord)opt);
        if (isChild) {
            anchor = new EscherChildAnchorRecord();
        } else {
            anchor = new EscherClientAnchorRecord();
            byte[] header = new byte[16];
            LittleEndian.putUShort((byte[])header, (int)0, (int)0);
            LittleEndian.putUShort((byte[])header, (int)2, (int)0);
            LittleEndian.putInt((byte[])header, (int)4, (int)8);
            anchor.fillFields(header, 0, null);
        }
        this._escherContainer.addChildRecord((EscherRecord)anchor);
        return this._escherContainer;
    }

    public double getLineWidth() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 459);
        return prop == null ? 0.0 : (double)prop.getPropertyValue() / 12700.0;
    }

    public void setLineWidth(double width) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)459, (int)(width * 12700.0));
    }

    public void setLineColor(Color color) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        if (color == null) {
            SimpleShape.setEscherProperty(opt, (short)511, 524288);
        } else {
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            SimpleShape.setEscherProperty(opt, (short)448, rgb);
            SimpleShape.setEscherProperty(opt, (short)511, color == null ? 0x180010 : 0x180018);
        }
    }

    public Color getLineColor() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty p1 = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 448);
        EscherSimpleProperty p2 = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 511);
        int p2val = p2 == null ? 0 : p2.getPropertyValue();
        Color clr = null;
        if ((p2val & 8) != 0 || (p2val & 0x10) != 0) {
            int rgb;
            int n = rgb = p1 == null ? 0 : p1.getPropertyValue();
            if (rgb >= 0x8000000) {
                int idx = rgb % 0x8000000;
                if (this.getSheet() != null) {
                    ColorSchemeAtom ca = this.getSheet().getColorScheme();
                    if (idx >= 0 && idx <= 7) {
                        rgb = ca.getColor(idx);
                    }
                }
            }
            Color tmp = new Color(rgb, true);
            clr = new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed());
        }
        return clr;
    }

    public int getLineDashing() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 462);
        return prop == null ? 1 : prop.getPropertyValue();
    }

    public void setLineDashing(int pen) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)462, pen == 1 ? -1 : pen);
    }

    public void setLineStyle(int style) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)461, style == 0 ? -1 : style);
    }

    public int getLineStyle() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 461);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public Color getFillColor() {
        return this.getFill().getForegroundColor();
    }

    public void setFillColor(Color color) {
        this.getFill().setForegroundColor(color);
    }

    public boolean getFlipHorizontal() {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        return (spRecord.getFlags() & 0x40) != 0;
    }

    public boolean getFlipVertical() {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        return (spRecord.getFlags() & 0x80) != 0;
    }

    public int getRotation() {
        int rot = this.getEscherProperty((short)4);
        int angle = (rot >> 16) % 360;
        return angle;
    }

    public void setRotation(int theta) {
        this.setEscherProperty((short)4, theta << 16);
    }

    public Rectangle2D getLogicalAnchor2D() {
        int angle;
        Rectangle2D anchor = this.getAnchor2D();
        if (this._parent != null) {
            Shape top = this._parent;
            while (top.getParent() != null) {
                top = top.getParent();
            }
            Rectangle2D clientAnchor = top.getAnchor2D();
            Rectangle2D spgrAnchor = ((ShapeGroup)top).getCoordinates();
            double scalex = spgrAnchor.getWidth() / clientAnchor.getWidth();
            double scaley = spgrAnchor.getHeight() / clientAnchor.getHeight();
            double x = clientAnchor.getX() + (anchor.getX() - spgrAnchor.getX()) / scalex;
            double y = clientAnchor.getY() + (anchor.getY() - spgrAnchor.getY()) / scaley;
            double width = anchor.getWidth() / scalex;
            double height = anchor.getHeight() / scaley;
            anchor = new Rectangle2D.Double(x, y, width, height);
        }
        if ((angle = this.getRotation()) != 0) {
            double centerX = anchor.getX() + anchor.getWidth() / 2.0;
            double centerY = anchor.getY() + anchor.getHeight() / 2.0;
            AffineTransform trans = new AffineTransform();
            trans.translate(centerX, centerY);
            trans.rotate(Math.toRadians(angle));
            trans.translate(-centerX, -centerY);
            Rectangle2D rect = trans.createTransformedShape(anchor).getBounds2D();
            if (anchor.getWidth() < anchor.getHeight() && rect.getWidth() > rect.getHeight() || anchor.getWidth() > anchor.getHeight() && rect.getWidth() < rect.getHeight()) {
                trans = new AffineTransform();
                trans.translate(centerX, centerY);
                trans.rotate(1.5707963267948966);
                trans.translate(-centerX, -centerY);
                anchor = trans.createTransformedShape(anchor).getBounds2D();
            }
        }
        return anchor;
    }

    public void draw(Graphics2D graphics) {
        AffineTransform at = graphics.getTransform();
        ShapePainter.paint(this, graphics);
        graphics.setTransform(at);
    }

    protected Record getClientDataRecord(int recordType) {
        Record[] records = this.getClientRecords();
        if (records != null) {
            for (int i = 0; i < records.length; ++i) {
                if (records[i].getRecordType() != (long)recordType) continue;
                return records[i];
            }
        }
        return null;
    }

    protected Record[] getClientRecords() {
        if (this._clientData == null) {
            EscherRecord r = Shape.getEscherChild(this.getSpContainer(), -4079);
            if (r != null && !(r instanceof EscherClientDataRecord)) {
                byte[] data = r.serialize();
                r = new EscherClientDataRecord();
                r.fillFields(data, 0, (EscherRecordFactory)new DefaultEscherRecordFactory());
            }
            this._clientData = (EscherClientDataRecord)r;
        }
        if (this._clientData != null && this._clientRecords == null) {
            byte[] data = this._clientData.getRemainingData();
            this._clientRecords = Record.findChildRecords(data, 0, data.length);
        }
        return this._clientRecords;
    }

    protected void updateClientData() {
        if (this._clientData != null && this._clientRecords != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this._clientRecords.length; ++i) {
                    this._clientRecords[i].writeOut(out);
                }
            }
            catch (Exception e) {
                throw new HSLFException(e);
            }
            this._clientData.setRemainingData(out.toByteArray());
        }
    }

    public void setHyperlink(Hyperlink link) {
        if (link.getId() == -1) {
            throw new HSLFException("You must call SlideShow.addHyperlink(Hyperlink link) first");
        }
        EscherClientDataRecord cldata = new EscherClientDataRecord();
        cldata.setOptions((short)15);
        this.getSpContainer().addChildRecord((EscherRecord)cldata);
        InteractiveInfo info = new InteractiveInfo();
        InteractiveInfoAtom infoAtom = info.getInteractiveInfoAtom();
        switch (link.getType()) {
            case 2: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)3);
                infoAtom.setHyperlinkType((byte)2);
                break;
            }
            case 3: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)4);
                infoAtom.setHyperlinkType((byte)3);
                break;
            }
            case 0: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)1);
                infoAtom.setHyperlinkType((byte)0);
                break;
            }
            case 1: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)2);
                infoAtom.setHyperlinkType((byte)1);
                break;
            }
            case 8: {
                infoAtom.setAction((byte)4);
                infoAtom.setJump((byte)0);
                infoAtom.setHyperlinkType((byte)8);
            }
        }
        infoAtom.setHyperlinkID(link.getId());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            info.writeOut(out);
        }
        catch (Exception e) {
            throw new HSLFException(e);
        }
        cldata.setRemainingData(out.toByteArray());
    }
}

